/**************************************************************************//**
 * \file       clSDS_IsVehicleMoving.h
 *
 * List Phonebook functions
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_IsVehicleMoving_h
#define clSDS_IsVehicleMoving_h


#include <vector>
#include <string>


class clSDS_IsVehicleMovingObserver;


class clSDS_IsVehicleMoving
{
   public:
      virtual ~clSDS_IsVehicleMoving();
      clSDS_IsVehicleMoving();
      void vRegisterObserver(clSDS_IsVehicleMovingObserver* pObserver);
      void vOnVehicleSpeedChange();

   private:
      void vNotifyObservers();
      std::vector<clSDS_IsVehicleMovingObserver*> _observers;
};


#endif
