/**************************************************************************//**
 * \file       clSDS_FMTemplate.cpp
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2018 Robert Bosch GmbH
 *             (C) 2018 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/

#include "application/clSDS_FMTemplate.h"

/**************************************************************************
* Constructor
***************************************************************************/
clSDS_FMTemplate::clSDS_FMTemplate(clSDS_FmChannelList* pFmChannelList) : _pFmChannelList(pFmChannelList)
{
}


/**************************************************************************
* Destructor
***************************************************************************/
clSDS_FMTemplate::~clSDS_FMTemplate()
{
}


/**************************************************************************
*
***************************************************************************/
std::map<std::string, std::string> clSDS_FMTemplate::translateHeaderValues(const std::map<std::string, std::string>& inputMap) const
{
   std::map<std::string, std::string> headerValueMap = inputMap;
   std::map<std::string, std::string>::const_iterator itname;
   std::map<std::string, std::string>::const_iterator itobj;
   itname = headerValueMap.find("ChannelName");
   itobj = headerValueMap.find("ObjectId");

   if (itname == headerValueMap.end() && itobj != headerValueMap.end())
   {
      std::string channelName = _pFmChannelList->getStationNameForObjectIdRDS(atoi(itobj->second.c_str()));
      headerValueMap.insert(std::pair<std::string, std::string>("ChannelName", channelName));
   }

   return headerValueMap;
}
