/**************************************************************************//**
 * \file       clSDS_FMNBestList.cpp
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/

#include "application/clSDS_FMNBestList.h"

/**************************************************************************
* Constructor
***************************************************************************/
clSDS_FMNBestList::clSDS_FMNBestList(clSDS_FmChannelList* pFmChannelList) : _pFmChannelList(pFmChannelList)
{
}


/**************************************************************************
* Destructor
***************************************************************************/
clSDS_FMNBestList::~clSDS_FMNBestList()
{
}


/**************************************************************************
*
***************************************************************************/
void clSDS_FMNBestList::vGetListInfo(sds2hmi_fi_tcl_e8_HMI_ListType::tenType /*listType*/)
{
}


/**************************************************************************
*
***************************************************************************/
tU32 clSDS_FMNBestList::u32GetSize()
{
   return _listItems.size();
}


/**************************************************************************
*
***************************************************************************/
std::vector<clSDS_ListItems> clSDS_FMNBestList::oGetItems(tU32 u32StartIndex, tU32 u32EndIndex)
{
   ::std::vector<clSDS_ListItems> oListItems;

   for (unsigned long u32Index = u32StartIndex; u32Index < ::std::min(u32EndIndex, u32GetSize()); u32Index++)
   {
      oListItems.push_back(_listItems[u32Index]);
   }
   return oListItems;
}


/**************************************************************************
*
***************************************************************************/
tVoid clSDS_FMNBestList::vProcessScreenData(const clSDS_ScreenData& screenData, const sds2hmi_fi_tcl_e8_PopUp_UpdateType& updateType)
{
   ::std::vector<tU32> stationIds = screenData.oGetListOfObjectIds();

   switch (updateType.enType)
   {
      case sds2hmi_fi_tcl_e8_PopUp_UpdateType::FI_EN_UPDATE_ALL:
      case sds2hmi_fi_tcl_e8_PopUp_UpdateType::FI_EN_UPDATE_RESTORE_PREVIOUS:
         _listItems.clear();
         for (tU32 i = 0; i < stationIds.size(); i++)
         {
            clSDS_ListItems listItem;
            listItem.oDescription.szString = _pFmChannelList->getStationNameForObjectIdRDS(stationIds[i]);
            if (listItem.oDescription.szString == "")
            {
               listItem.oDescription.szString = "Unknown Station";
            }
            _listItems.push_back(listItem);
         }
         break;
      default:
         break;
   }
}


/**************************************************************************
*
***************************************************************************/
tBool clSDS_FMNBestList::bSelectElement(tU32 /*u32SelectedIndex*/)
{
   return true;
}


/**************************************************************************
* TODO jnd2hi: wouldn't it be sufficient to pass a list of strings here?
* It seems more complicated than needed that the client setting the list
* has to deal with clSDS_ListItems.
***************************************************************************/
void clSDS_FMNBestList::setItems(std::vector<clSDS_ListItems> items)
{
   _listItems = items;
}
