/**************************************************************************//**
 * \file       clSDS_EcnrHandler.h
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_EcnrHandler_h
#define clSDS_EcnrHandler_h


#include "org/bosch/ecnr/serviceProxy.h"


/**
 * see nincg3\ai_audio\components\ECNR\config\rnaivi\ecnr-configuration-data.h
 * #define ECNR_APPID_SDS                          (unsigned char) 3
 * #define SDS_DATASET_2                           (unsigned short) 402
 */
#define ECNR_APP_ID        3
#define ECNR_CONFIG_ID     402


class clSDS_EcnrHandler
   : public org::bosch::ecnr::service::EcnrInitializeCallbackIF
   , public org::bosch::ecnr::service::EcnrDestroyCallbackIF
   , public org::bosch::ecnr::service::EcnrStartAudioExtCallbackIF
   , public org::bosch::ecnr::service::EcnrStopAudioCallbackIF
{
   public:
      clSDS_EcnrHandler(::boost::shared_ptr< org::bosch::ecnr::service::ServiceProxy > ecnrProxy);
      virtual ~clSDS_EcnrHandler();

      void initialize();
      void destroy();
      void startAudio();
      void stopAudio();

   private:
      virtual void onEcnrInitializeError(
         const ::boost::shared_ptr< org::bosch::ecnr::service::ServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::ecnr::service::EcnrInitializeError >& error);
      virtual void onEcnrInitializeResponse(
         const ::boost::shared_ptr< org::bosch::ecnr::service::ServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::ecnr::service::EcnrInitializeResponse >& response);

      virtual void onEcnrDestroyError(
         const ::boost::shared_ptr< org::bosch::ecnr::service::ServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::ecnr::service::EcnrDestroyError >& error);
      virtual void onEcnrDestroyResponse(
         const ::boost::shared_ptr< org::bosch::ecnr::service::ServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::ecnr::service::EcnrDestroyResponse >& response);

      virtual void onEcnrStartAudioExtError(
         const ::boost::shared_ptr< org::bosch::ecnr::service::ServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::ecnr::service::EcnrStartAudioExtError >& error);
      virtual void onEcnrStartAudioExtResponse(
         const ::boost::shared_ptr< org::bosch::ecnr::service::ServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::ecnr::service::EcnrStartAudioExtResponse >& response);

      virtual void onEcnrStopAudioError(
         const ::boost::shared_ptr< org::bosch::ecnr::service::ServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::ecnr::service::EcnrStopAudioError >& error);
      virtual void onEcnrStopAudioResponse(
         const ::boost::shared_ptr< org::bosch::ecnr::service::ServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::ecnr::service::EcnrStopAudioResponse >& response);

      boost::shared_ptr< org::bosch::ecnr::service::ServiceProxy > _ecnrProxy;
};


#endif
