/**************************************************************************//**
 * \file       clSDS_Display.h
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_Display_h
#define clSDS_Display_h

#include "view_db/Sds_ViewDB.h"
#include "application/clSDS_SDSStatusObserver.h"
#include "application/GuiService.h"
#include "application/PopUpService.h"
#include "application/clSDS_Template.h"
#include "external/sds2hmi_fi.h"

class clSDS_SDSStatus;
class clSDS_ScreenData;
class clSDS_ListItems;
class clSDS_View;

class clSDS_Display : public clSDS_SDSStatusObserver
{
   public:
      virtual ~clSDS_Display();
      clSDS_Display(
         clSDS_SDSStatus* pSdsStatus,
         GuiService& guiService,
         PopUpService& popupService);

      void cursorMoved(uint32 cursorIndex);
      tVoid vCloseView(tBool bError = FALSE);
      std::string getScreenId() const;
      tVoid vShowSDSView(clSDS_ScreenData& oScreenData, uint32 pageNumber, uint32 numberOfPages, tU8 nextPreviousOptions, unsigned int maxItemsperPage, sds2hmi_fi_tcl_e8_PopUp_UpdateType screenUpdateType);
      bool hasCommandList() const;
      void setScreenVariableData(clSDS_ScreenData& oScreenData);
      std::map<std::string, std::string> getCombinedScreenVariableData() const;
      unsigned int getPageNumber() const;
      unsigned int getMaxItemsPerPage() const;
      void cursorIndexChanged(uint32 index);
      void setSpeakableList(bool isSpeakableList);

      tVoid vAddTemplateHandler(std::string, clSDS_Template*);

   private:
      enum State
      {
         INACTIVE,
         ACTIVE
      };

      enum
      {
         SINGLE_PAGE = 1,
         PREVIOUS_PAGE = 2,
         NEXT_PAGE = 4,
         NEXT_PREVIOUS_PAGE = 6
      };
      void SetSpeechInputState();
      bool setIsSpeakableList();
      void getCommandListAvailability(const clSDS_View& sdsView);
      tVoid vSDSStatusChanged();
      void createAndShowView();
      tVoid vShowView(const sds_gui_fi::PopUpService::PopupRequestSignal& popupRequestSignal, const std::string& viewId);
      uint32 getSelectableCommandIndex() const;
      sds_gui_fi::PopUpService::NextPreviousOption getNextPreviousOption(tU8 nextPreviousOtion);

      GuiService& _guiService;
      PopUpService& _popupService;
      clSDS_SDSStatus* _pSdsStatus;

      std::string _viewId;
      std::map<std::string, std::string> _screenVariableData;
      std::vector<clSDS_ListItems> _items;
      std::map<std::string, std::string> _headerValueMap;
      std::map<std::string, std::string> _stickyHeaderValueMap;
      std::map<std::string, clSDS_Template*> _templateHandlerMap;
      sds_gui_fi::PopUpService::SpeechInputState _speechInputState;
      std::string _headerTemplateId;
      std::string _stickyHeaderTemplateId;
      bool _isCommandListAvailable;
      uint32 _cursorIndex;
      State _state;
      uint32 _pageNumber;
      uint32 _numberOfPages;
      sds_gui_fi::PopUpService::NextPreviousOption _nextPreviousOptions;
      bool _speakableList;
      unsigned int _maxItemsPerPage;
      sds2hmi_fi_tcl_e8_PopUp_UpdateType _screenUpdateType;
};


#endif
