/**************************************************************************//**
 * \file       clSDS_DabChannelList.h
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_DabChannelList_h
#define clSDS_DabChannelList_h


#include "sds_dab_fi/SdsDabServiceProxy.h"
#include "dabtuner_main_fiProxy.h"
#include "dabtuner_main_fi_types.h"


struct DabServiceList_Elem
{
   std::string _psName;
   bool _serviceSelected;
};


class clSDS_TunerStateObserver;

class clSDS_DabChannelList
   : public asf::core::ServiceAvailableIF
   , public ::dabtuner_main_fi::FID_DAB_G_LIST_UPDATECallbackIF
   , public ::dabtuner_main_fi::FID_DAB_S_SRV_SELECTCallbackIF
   , public sds_dab_fi::SdsDabService::StoreDabChannelNamesCallbackIF
   , public ::dabtuner_main_fi::FID_DAB_G_SRVLIST_NOTIFICATIONCallbackIF

{
   public:
      clSDS_DabChannelList(
         ::boost::shared_ptr< sds_dab_fi::SdsDabService::SdsDabServiceProxy > _pSdsDabProxy,
         ::boost::shared_ptr<dabtuner_main_fi::Dabtuner_main_fiProxy> tunerDabProxy);
      virtual ~clSDS_DabChannelList();

      virtual void onStoreDabChannelNamesError(
         const ::boost::shared_ptr< sds_dab_fi::SdsDabService::SdsDabServiceProxy >& proxy,
         const ::boost::shared_ptr< sds_dab_fi::SdsDabService::StoreDabChannelNamesError >& error);
      virtual void onStoreDabChannelNamesResponse(
         const ::boost::shared_ptr< sds_dab_fi::SdsDabService::SdsDabServiceProxy >& proxy,
         const ::boost::shared_ptr< sds_dab_fi::SdsDabService::StoreDabChannelNamesResponse >& response);

      void onAvailable(
         const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange);
      void onUnavailable(
         const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange);
      void setDabChannelListObserver(clSDS_TunerStateObserver* pTunerStateObserver);
      virtual void onFID_DAB_S_SRV_SELECTError(const ::boost::shared_ptr< ::dabtuner_main_fi::Dabtuner_main_fiProxy >& /*proxy*/,
            const ::boost::shared_ptr< ::dabtuner_main_fi::FID_DAB_S_SRV_SELECTError >& /*error*/);
      virtual void onFID_DAB_S_SRV_SELECTResult(const ::boost::shared_ptr< ::dabtuner_main_fi::Dabtuner_main_fiProxy >& /*proxy*/,
            const ::boost::shared_ptr< ::dabtuner_main_fi::FID_DAB_S_SRV_SELECTResult >& /*result*/);

      uint32 getDABIDForObjectID(uint32 objectID);

      virtual void onFID_DAB_G_LIST_UPDATEError(const ::boost::shared_ptr< ::dabtuner_main_fi::Dabtuner_main_fiProxy >& proxy,
            const ::boost::shared_ptr< ::dabtuner_main_fi::FID_DAB_G_LIST_UPDATEError >& error);
      virtual void onFID_DAB_G_LIST_UPDATEStatus(const ::boost::shared_ptr< ::dabtuner_main_fi::Dabtuner_main_fiProxy >& proxy,
            const ::boost::shared_ptr< ::dabtuner_main_fi::FID_DAB_G_LIST_UPDATEStatus >& status);

      virtual void onFID_DAB_G_SRVLIST_NOTIFICATIONError(const ::boost::shared_ptr< ::dabtuner_main_fi::Dabtuner_main_fiProxy >& /*proxy*/,
            const ::boost::shared_ptr< ::dabtuner_main_fi::FID_DAB_G_SRVLIST_NOTIFICATIONError >& /*error*/);

      virtual void onFID_DAB_G_SRVLIST_NOTIFICATIONStatus(const ::boost::shared_ptr< ::dabtuner_main_fi::Dabtuner_main_fiProxy >& /*proxy*/,
            const ::boost::shared_ptr< ::dabtuner_main_fi::FID_DAB_G_SRVLIST_NOTIFICATIONStatus >& /*status*/);

   private:
      bool isDABListUpdated();
      void updateDabObjectIDToChannelNameMap();

      boost::shared_ptr< sds_dab_fi::SdsDabService::SdsDabServiceProxy > _sdsDabProxy;
      boost::shared_ptr<dabtuner_main_fi::Dabtuner_main_fiProxy> _tunerDabProxy;

      std::vector<sds_dab_fi::SdsDabService::DABChannelItem> _dabChannelList;

      /*_channelListElems contains the dab channel list info from tuner*/

      clSDS_TunerStateObserver* _pTunerStateObserver;
      std::map<uint32 , std::string> _dabObjectIDToServiceLabelMap;
};


#endif
