/**************************************************************************//**
 * \file       clSDS_DTMFHandler.cpp
 *
 * clSDS_DTMFHandler class implementation
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#include "clSDS_DTMFHandler.h"
#include "SdsAdapter_Trace.h"

#define ETG_ENABLED
#include "trace_interface.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_TTFIS_CMD_PREFIX      "SdsAdapter_"
#define ETG_I_TRACE_CHANNEL         TR_TTFIS_SAAL
#define ETG_DEFAULT_TRACE_CLASS     TR_CLASS_SDSADP_DETAILS
#include "trcGenProj/Header/clSDS_DTMFHandler.cpp.trc.h"
#endif

using namespace most_Tel_fi_types;

clSDS_DTMFHandler::clSDS_DTMFHandler(clSDS_SessionControl* poSessionControl)
   : _pSessionControl(poSessionControl)
{
}


clSDS_DTMFHandler::~clSDS_DTMFHandler()
{
   _pSessionControl = NULL;
}


void clSDS_DTMFHandler::callStatusChanged(T_e8_TelCallStatus firstCallstatus, T_e8_TelCallStatus secondCallstatus)
{
   // TODO jnd2hi: get rid of hard-coded view id names below
   if ((firstCallstatus == T_e8_TelCallStatus__e8IDLE) && (secondCallstatus == T_e8_TelCallStatus__e8IDLE)
         && ((_viewId == "SR_PHO_InCall") || (_viewId == "SR_PHO_InCall2")) && (_pSessionControl != NULL))
   {
      ETG_TRACE_USR1(("callStatusChanged to IDLE when DTMF is active : vAbortSession"));
      _viewId = "";
      _pSessionControl->vAbortSession();
   }
}


void clSDS_DTMFHandler::viewIdChanged(const std::string& viewId)
{
   _viewId = viewId;
}
