/**************************************************************************//**
 * \file       clSDS_ContactNumberList.h
 *
 * See .cpp file for description.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_ContactNumberList_h
#define clSDS_ContactNumberList_h


#include <string>
#include <vector>

#include "application/clSDS_List.h"

class clSDS_PhonebookList;

class clSDS_ContactNumberList : public clSDS_List
{
   public:
      virtual ~clSDS_ContactNumberList();
      clSDS_ContactNumberList(clSDS_PhonebookList* pPhonebookList);
      tU32 u32GetSize();
      std::vector<clSDS_ListItems> oGetItems(tU32 u32StartIndex, tU32 u32EndIndex);
      tBool bSelectElement(tU32 u32SelectedIndex);
      std::string oGetSelectedItem(tU32 u32Index);

   private:
      std::string oGetConfirmationItem(tU32 u32Index) const;
      std::string oGetItem(tU32 u32Index) const;

      tVoid vGetListInfo(sds2hmi_fi_tcl_e8_HMI_ListType::tenType listType);

      clSDS_PhonebookList* _pPhonebookList;
};


#endif
