/**************************************************************************//**
 * \file       clSDS_ContactNumberList.cpp
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#include "application/clSDS_ContactNumberList.h"
#include "application/clSDS_Iconizer.h"
#include "application/clSDS_PhoneNumberFormatter.h"
#include "application/clSDS_PhonebookList.h"
#include "application/clSDS_StringVarList.h"
#include "external/sds2hmi_fi.h"


/**************************************************************************//**
*Destructor
******************************************************************************/
clSDS_ContactNumberList::~clSDS_ContactNumberList()
{
   _pPhonebookList = NULL;
}


/**************************************************************************//**
*Constructor
******************************************************************************/
clSDS_ContactNumberList::clSDS_ContactNumberList(clSDS_PhonebookList* pPhonebookList) : _pPhonebookList(pPhonebookList)
{
}


/**************************************************************************//**
*
******************************************************************************/
tBool clSDS_ContactNumberList::bSelectElement(tU32 u32SelectedIndex)
{
   return TRUE;
}


/**************************************************************************//**
*
******************************************************************************/
std::vector<clSDS_ListItems> clSDS_ContactNumberList::oGetItems(tU32 u32StartIndex, tU32 u32EndIndex)
{
   std::vector<clSDS_ListItems> oListItems;
   if (u32StartIndex < u32GetSize())
   {
      for (tU32 u32Index = u32StartIndex; u32Index < std::min(u32EndIndex, u32GetSize()); u32Index++)
      {
         clSDS_ListItems oListItem;
         oListItem.oDescription.szString = oGetItem(u32Index);
         oListItems.push_back(oListItem);
      }
   }
   return oListItems;
}


/**************************************************************************//**
*
******************************************************************************/
std::string clSDS_ContactNumberList::oGetItem(tU32 u32Index) const
{
   if (_pPhonebookList != NULL)
   {
      std::string oNumber(_pPhonebookList->oGetPhoneNumbers().oPBDetails_TelNumber[u32Index]);
      if (!oNumber.empty())
      {
         tU8 u8IconType = _pPhonebookList->oGetPhoneNumbers().u8PBDetails_IconType[u32Index];
         return clSDS_Iconizer::oAddIconPrefix(u8IconType, clSDS_PhoneNumberFormatter::oFormatNumber(oNumber));
      }
   }
   return " ";
}


/**************************************************************************//**
*
******************************************************************************/
tU32 clSDS_ContactNumberList::u32GetSize()
{
   if (_pPhonebookList != NULL)
   {
      return _pPhonebookList->u32GetContactDetailCount();
   }
   else
   {
      return 0;
   }
}


/**************************************************************************//**
*
******************************************************************************/
std::string clSDS_ContactNumberList::oGetConfirmationItem(tU32 u32Index) const
{
   if ((_pPhonebookList != NULL) && (u32Index > 0))
   {
      std::string oNumber(_pPhonebookList->oGetPhoneNumbers().oPBDetails_TelNumber[u32Index - 1]);
      std::string oName(_pPhonebookList->oGetPhoneNumbers().oPBDetails_Name);
      tU8 u8IconType = _pPhonebookList->oGetPhoneNumbers().u8PBDetails_IconType[u32Index - 1];

      return clSDS_Iconizer::oAddIconInfix(oName, u8IconType, clSDS_PhoneNumberFormatter::oFormatNumber(oNumber));
   }
   else
   {
      return ("");
   }
}


/**************************************************************************//**
*
******************************************************************************/
std::string clSDS_ContactNumberList::oGetSelectedItem(tU32 u32Index)
{
   if ((_pPhonebookList != NULL) && (u32Index > 0))
   {
      return _pPhonebookList->oGetPhoneNumbers().oPBDetails_TelNumber[u32Index - 1];
   }
   return "";
}


tVoid clSDS_ContactNumberList::vGetListInfo(sds2hmi_fi_tcl_e8_HMI_ListType::tenType listType)
{
   NORMAL_M_ASSERT(listType == sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_CONTACT_AMBIGUITY);

   if (_pPhonebookList != NULL)
   {
      _pPhonebookList->vUpdateHeadLineTagForSingleContact();
   }
   notifyListObserver();
}
