/**************************************************************************//**
 * \file       clSDS_ConfigurationFlags.h
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_ConfigurationFlags_h
#define clSDS_ConfigurationFlags_h


#include "external/sds2hmi_fi.h"
#include <map>
#include <string>
#include <stddef.h>


/* This enum describes the possible POI Regions due to the fact that POI categories differ depending on region
 * The distinction is made in getNaviPOIRegion() based on the SDN Region,
 * considering also the fact that multiple SDN regions share the same POI Region
 * e.g.
 * SDN_EUR, SDN_TKY and SDN_RUS belong to the same POI_EUR region
 * SDN_PRC and SDN_TWN belong to the same POI_PRC region
 * SDN_ASR, SDN_SAF, SDN_IND and SDN_KOR belong to POI_OTH (other) group.
 */
enum POIRegion
{
   POI_NAM,
   POI_EUR,
   POI_GCC,
   POI_PRC,
   POI_JPN,
   POI_LAC,
   POI_OTH,
   MAX_POI_REGIONS //keep this as last enum value
};


/**
 * This enum describes the possible SDN Regions (different countries belong to the same SDN region)
 * It is useful in order to identify the different POI regions (POI categories differ depending on SDN region)
 */
enum SDNRegion
{
   SDN_NAM,
   SDN_LAC,
   SDN_EUR,
   SDN_TKY,
   SDN_RUS,
   SDN_ASR,
   SDN_SAF,
   SDN_GCC,
   SDN_IND,
   SDN_PRC,
   SDN_TWN,
   SDN_JPN,
   SDN_KOR,
   MAX_SDN_REGIONS //keep this as last enum value
};


enum TCUVoiceAssit
{
   TCU_CONNECT_VOICE_MENU = 0,
   TCU_CONNECT_IN_TOUCH = 1u,
   TCU_CONNECT_VOICE_ASSIT_UNKNOWN
};


class clSDS_ConfigurationFlags
{
   public:

      clSDS_ConfigurationFlags();
      virtual ~clSDS_ConfigurationFlags();

      static bool getNavKey();
      static bool isVDEAvailble();
      static bool getDomainKey();
      static bool getMapModeStatusKey();
      static bool getNavMultiLingualVDE();
      static bool getNavAdrsKey();
      static bool getNavStateAvailable();
      static bool getNavCountryAvailable();
      static bool getNavJapaneseAddressInput();
      static bool getNavIntersectionKey();

      static bool getPOIKey();
      static bool getPOICatKey();

      static bool getAudHDKey();
      static bool getAudRDSKey();
      static bool getAudDABKey();
      static bool getAudSXMKey();
      static bool getAudTVKey();
      static bool getVINFMaintenancekey();
      static bool getVINFFuelEconomykey();
      static bool getInfCelsiuskey();
      static unsigned int getAudFreqTypeKey();

      static bool getInfTrafficKey();
      static bool getInfHEVKey();
      static bool getInfKey();
      static bool getEveKey();
      static bool getInfSXMKey();
      static bool getInfFeeds();
      static bool getPOIAddressInfo();
      static bool getVehicleInfoKey();

      static bool getBluetoothPhoneEnabledKey();
      static bool getHapticModeAfterThirdError();
      static bool getTaxiAvailabilityKey();
      static bool getPhoneInCallFeatureKey();
      static bool getSwitchThroughDomainsKey();
      static bool getPromptOnFocusMovementKey();
      static bool getElectricVehicleKey();
      static bool getCDAvailableKey();
      static bool getWhereAmIKey();
      static bool getDVDAvailableKey();
      static bool getMusicBoxAvailableKey();

      static void setDynamicVariable(const std::string& name, const std::string& value);
      static void setDynamicVariable(const std::string& name, unsigned int value);

      static std::map<std::string, std::string> getConfigurationFlags();

      static void readConfigFile();

      static void getConfigDataMap(std::map< std::string, std::string>& configMap);

      static sds2hmi_fi_tcl_e8_INFO_TCUType::tenType getTcuInformationOnVariantType();
      static bool isCDTrackAvailable();
      static bool isVoiceBargeInFeatureEnable();
      static bool isVDEForEntryNaviEnable();
      static bool isPOIExtendedSearchLocation();
      static bool isDisableNavigationForVDEUnavailable();
      static bool getMapUpdateStatus();
      static bool getSIRIStatus();
      static bool getVoiceAssistant();
      static bool getAndroidAuto();
      static bool getCarplay();
      static bool disableTCUforCurrentRegion();
      static bool isA2S1();

   private:
      static std::map<std::string, std::string> dynamicVariables;
      static std::map< std::string, std::string> configDataFromFile;
      static POIRegion getNaviPOIRegion();
      static SDNRegion getSDNRegion();
      static TCUVoiceAssit getTCUVoiceAssitOnVariantType();
};


#endif
