/**************************************************************************//**
 * \file       clSDS_AmbigNumberList.h
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/

#ifndef clSDS_AmbigNumberList_h
#define clSDS_AmbigNumberList_h
#include "application/clSDS_List.h"
#include "application/PhonebookObserver.h"

class PhonebookContacts;
class AmbigNumberListObserver;

class clSDS_AmbigNumberList : public clSDS_List, public PhonebookObserver
{
   public:
      clSDS_AmbigNumberList(PhonebookContacts* phonebookContacts);
      virtual ~clSDS_AmbigNumberList();

      void setAmbigNumberList(const std::vector<std::pair <std::string, unsigned int> >& contactNumbers);
      void contactsDetailsUpdated(std::vector<std::pair <std::string, unsigned int> > contactDetails);
      void registerObservers(AmbigNumberListObserver* obs);

   private:
      virtual tU32 u32GetSize();
      virtual std::vector<clSDS_ListItems> oGetItems(tU32 u32StartIndex, tU32 u32EndIndex);
      virtual tBool bSelectElement(tU32 u32SelectedIndex);
      virtual tVoid vGetListInfo(sds2hmi_fi_tcl_e8_HMI_ListType::tenType listType);
      virtual std::string oGetSelectedItem(tU32 u32Index);

      std::string oGetItem(tU32 u32Index) const;
      std::string oGetPhoneNumberType(tU32 u32Index) const;
      std::vector<sds2hmi_fi_tcl_HMIElementDescription> getHmiElementDescription(unsigned int index);
      void notifyAmbigNumberUpdated(const std::pair<std::string , unsigned int>& number);

      std::vector<std::pair <std::string, unsigned int> > _ambigContactNumbers;
      PhonebookContacts* _pPhonebookContacts;
      std::vector<AmbigNumberListObserver*> _ambigNumberListObservers;
};


#endif
