/**************************************************************************//**
 * \file       clSDS_AmbigContactList.cpp
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#include "application/clSDS_AmbigContactList.h"
#include "application/clSDS_StringVarList.h"
#include "application/PhonebookContacts.h"
#include "SdsAdapter_Trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_SDSADP_DETAILS
#include "trcGenProj/Header/clSDS_AmbigContactList.cpp.trc.h"
#endif

clSDS_AmbigContactList::clSDS_AmbigContactList(PhonebookContacts* phonebookContacts)
   : _pPhonebookContacts(phonebookContacts)
{
   if (_pPhonebookContacts)
   {
      _pPhonebookContacts->registerObserver(this);
   }
}


clSDS_AmbigContactList::~clSDS_AmbigContactList()
{
   _pPhonebookContacts = NULL;
}


void clSDS_AmbigContactList::setAmbigContactList(std::vector<std::string> contactNames)
{
   _ambigContactNames = contactNames;
}


tU32 clSDS_AmbigContactList::u32GetSize()
{
   return _ambigContactNames.size();
}


std::vector<clSDS_ListItems> clSDS_AmbigContactList::oGetItems(tU32 u32StartIndex, tU32 u32EndIndex)
{
   std::vector<clSDS_ListItems> oListItems;
   if (u32StartIndex < u32GetSize())
   {
      for (tU32 u32Index = u32StartIndex; u32Index < std::min(u32EndIndex, u32GetSize()); u32Index++)
      {
         clSDS_ListItems oListItem;
         oListItem.oDescription.szString = oGetItem(u32Index);
         oListItems.push_back(oListItem);
      }
   }
   return oListItems;
}


tBool clSDS_AmbigContactList::bSelectElement(tU32 u32SelectedIndex)
{
   if (u32SelectedIndex > 0 && _pPhonebookContacts)
   {
      _pPhonebookContacts->setSelectedIndex(u32SelectedIndex - 1);
      clSDS_StringVarList::vSetVariable("$(ContactName)", oGetSelectedItem(u32SelectedIndex));
      ETG_TRACE_USR4(("clSDS_AmbigContactList::bSelectElement $(ContactName) = %s", oGetSelectedItem(u32SelectedIndex).c_str()));
      return TRUE;
   }
   return FALSE;
}


tVoid clSDS_AmbigContactList::vGetListInfo(sds2hmi_fi_tcl_e8_HMI_ListType::tenType listType)
{
   switch (listType)
   {
      case sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_PHONE_PB_ALL_ENTRIES:
      case sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_PHONE_VB_ALL_ENTRIES:
         _ambigContactNames.clear();
         if (_pPhonebookContacts)
         {
            _pPhonebookContacts->retrieveContactsList(listType);
         }
         break;

      default:
         notifyListObserver();
         break;
   }
}


std::string clSDS_AmbigContactList::oGetSelectedItem(tU32 u32Index)
{
   ETG_TRACE_USR4(("clSDS_AmbigContactList::oGetSelectedItem index = %d", u32Index));
   if (u32Index > 0)
   {
      return oGetItem(u32Index - 1);
   }
   return "";
}


std::string clSDS_AmbigContactList::oGetItem(tU32 u32Index) const
{
   std::string str;

   if (_ambigContactNames.size() > u32Index)
   {
      str = _ambigContactNames[u32Index];
   }

   return str;
}


std::vector<sds2hmi_fi_tcl_HMIElementDescription> clSDS_AmbigContactList::getHmiElementDescription(unsigned int index)
{
   std::vector<sds2hmi_fi_tcl_HMIElementDescription> hmiElementDescription;
   if (0 < index && index <= _ambigContactNames.size())
   {
      sds2hmi_fi_tcl_HMIElementDescription element;
      element.DescriptorTag.enType = sds2hmi_fi_tcl_e8_WordType::FI_EN_CONTACTNAME;
      element.DescriptorValue = _ambigContactNames.at(index - 1).c_str();
      hmiElementDescription.push_back(element);
   }
   return hmiElementDescription;
}


void clSDS_AmbigContactList::contactsListUpdated(std::vector<std::string> contactNames)
{
   ETG_TRACE_USR4(("clSDS_AmbigContactList::contactsListUpdated - count = %d", contactNames.size()));
   setAmbigContactList(contactNames);
   notifyListObserver();
}
