/**************************************************************************//**
 * \file       clSDS_AmChannelList.h
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_AmChannelList_h
#define clSDS_AmChannelList_h

#include "sds_am_fi/SdsAmServiceProxy.h"
#include "tuner_main_fiProxy.h"
#include "tuner_main_fi_types.h"

class clSDS_TunerStateObserver;

class clSDS_AmChannelList
   : public asf::core::ServiceAvailableIF
   , public sds_am_fi::SdsAmService::StoreHDChannelNamesCallbackIF
   , public tuner_main_fi::FID_TUN_G_SURVIELLANCE_LISTUPDATECallbackIF
{
   public :
      clSDS_AmChannelList();     // default constructor without implementation
      clSDS_AmChannelList(
         ::boost::shared_ptr< sds_am_fi::SdsAmService::SdsAmServiceProxy > _pSdsAmProxy,
         ::boost::shared_ptr< tuner_main_fi::Tuner_main_fiProxy > tun_fi_proxy);
      virtual ~clSDS_AmChannelList();

      void onAvailable(
         const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange);
      void onUnavailable(
         const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange);
      virtual void onStoreHDChannelNamesError(
         const ::boost::shared_ptr< sds_am_fi::SdsAmService::SdsAmServiceProxy >& proxy,
         const ::boost::shared_ptr< sds_am_fi::SdsAmService::StoreHDChannelNamesError >& error);
      virtual void onStoreHDChannelNamesResponse(
         const ::boost::shared_ptr< sds_am_fi::SdsAmService::SdsAmServiceProxy >& proxy,
         const ::boost::shared_ptr< sds_am_fi::SdsAmService::StoreHDChannelNamesResponse >& response);
      virtual void onFID_TUN_G_SURVIELLANCE_LISTUPDATEError(const ::boost::shared_ptr< tuner_main_fi::Tuner_main_fiProxy >& proxy,
            const ::boost::shared_ptr< tuner_main_fi::FID_TUN_G_SURVIELLANCE_LISTUPDATEError >& error);
      virtual void onFID_TUN_G_SURVIELLANCE_LISTUPDATEStatus(const ::boost::shared_ptr< tuner_main_fi::Tuner_main_fiProxy >& proxy,
            const ::boost::shared_ptr< tuner_main_fi::FID_TUN_G_SURVIELLANCE_LISTUPDATEStatus >& status);

      void setAmChannelListObserver(clSDS_TunerStateObserver* pTunerStateObserver);
      uint32 getAudioProgramForObjectID(uint32 objectID);
      uint32 getFrequencyForObjectID(uint32 objectID);

   private:
      bool isAMHDListUpdated();
      void updateAmObjectIDToChannelNameMap();
      void setObjectIdsforHDStationList();

      boost::shared_ptr< sds_am_fi::SdsAmService::SdsAmServiceProxy > _sdsAmProxy;
      boost::shared_ptr< ::tuner_main_fi::Tuner_main_fiProxy > _tunerProxy;
      clSDS_TunerStateObserver* _pTunerStateObserver;
      std::vector<sds_am_fi::SdsAmService::AMChannelItem> _amChannelList;
      std::map<uint32 , std::string> _amObjectIDToChannelNameMap;
};


#endif
