/**************************************************************************//**
 * \file       UserProfile.h
 *
 * See .cpp file for description.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef UserProfile_h
#define UserProfile_h


#include "bosch/cm/profileProxy.h"


class SystemVoiceSettings;


class UserProfile
   : public asf::core::ServiceAvailableIF
   , ::bosch::cm::profile::CopyProfileCallbackIF
   , ::bosch::cm::profile::DeleteProfileCallbackIF
   , ::bosch::cm::profile::DataChangedCallbackIF
   , ::bosch::cm::profile::CreateProfileCallbackIF
   , ::bosch::cm::profile::DoRegisterAppCallbackIF
{
   public:
      UserProfile(::boost::shared_ptr< bosch::cm::profile::ProfileProxy > profileProxy, SystemVoiceSettings* systemVoiceSettings);
      virtual ~UserProfile();
      virtual void onUnavailable(
         const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange);

      virtual void onAvailable(
         const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange);
      virtual void onCopyProfileError(const ::boost::shared_ptr< bosch::cm::profile::ProfileProxy >& proxy,
                                      const ::boost::shared_ptr< bosch::cm::profile::CopyProfileError >& error);

      virtual void onCopyProfileUpdate(const ::boost::shared_ptr< bosch::cm::profile::ProfileProxy >& proxy,
                                       const ::boost::shared_ptr< bosch::cm::profile::CopyProfileUpdate >& update);

      virtual void onDeleteProfileError(const ::boost::shared_ptr< bosch::cm::profile::ProfileProxy >& proxy,
                                        const ::boost::shared_ptr< bosch::cm::profile::DeleteProfileError >& error) ;

      virtual void onDeleteProfileUpdate(const ::boost::shared_ptr< bosch::cm::profile::ProfileProxy >& proxy,
                                         const ::boost::shared_ptr< bosch::cm::profile::DeleteProfileUpdate >& update) ;

      virtual void onDataChangedError(const ::boost::shared_ptr< bosch::cm::profile::ProfileProxy >& proxy,
                                      const ::boost::shared_ptr< bosch::cm::profile::DataChangedError >& error);

      virtual void onDataChangedUpdate(const ::boost::shared_ptr< bosch::cm::profile::ProfileProxy >& proxy,
                                       const ::boost::shared_ptr< bosch::cm::profile::DataChangedUpdate >& update) ;

      virtual void onCreateProfileError(const ::boost::shared_ptr< bosch::cm::profile::ProfileProxy >& proxy,
                                        const ::boost::shared_ptr< bosch::cm::profile::CreateProfileError >& error);

      virtual void onCreateProfileUpdate(const ::boost::shared_ptr< bosch::cm::profile::ProfileProxy >& proxy,
                                         const ::boost::shared_ptr< bosch::cm::profile::CreateProfileUpdate >& update);

      virtual void onDoRegisterAppError(const ::boost::shared_ptr< bosch::cm::profile::ProfileProxy >& proxy,
                                        const ::boost::shared_ptr< bosch::cm::profile::DoRegisterAppError >& error);

      virtual void onDoRegisterAppResponse(const ::boost::shared_ptr< bosch::cm::profile::ProfileProxy >& proxy,
                                           const ::boost::shared_ptr< bosch::cm::profile::DoRegisterAppResponse >& response);

   private:
      ::boost::shared_ptr< bosch::cm::profile::ProfileProxy > _profileProxy;
      uint8 _appID;
      SystemVoiceSettings* _systemVoiceSettings;
};


#endif
