/**************************************************************************//**
 * \file       UserProfile.cpp
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#include "application/UserProfile.h"
#include "SdsAdapter_Trace.h"
#include "SystemVoiceSettings.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SDSADP_DETAILS
#include "trcGenProj/Header/UserProfile.cpp.trc.h"
#endif

using namespace bosch::cm::profile;

/**************************************************************************//**
 * @Constructor
 ******************************************************************************/
UserProfile::UserProfile(
   ::boost::shared_ptr< bosch::cm::profile::ProfileProxy > profileProxy, SystemVoiceSettings* systemVoiceSettings)
   : _profileProxy(profileProxy)
   , _systemVoiceSettings(systemVoiceSettings)
{
   _appID = 0u;
}


/**************************************************************************//**
 * @Destructor
  ******************************************************************************/
UserProfile::~UserProfile()
{
}


/**************************************************************************//**
 *
 ******************************************************************************/

void UserProfile::onUnavailable(
   const boost::shared_ptr<asf::core::Proxy>& proxy,
   const asf::core::ServiceStateChange& /*stateChange*/)
{
   if (proxy == _profileProxy)
   {
      _profileProxy->sendDataChangedDeregisterAll();
      _profileProxy->sendCopyProfileDeregisterAll();
      _profileProxy->sendDeleteProfileDeregisterAll();
      _profileProxy->sendCreateProfileDeregisterAll();
   }
}


/**************************************************************************//**
 *
 ******************************************************************************/

void UserProfile::onAvailable(
   const boost::shared_ptr<asf::core::Proxy>& proxy,
   const asf::core::ServiceStateChange& /*stateChange*/)
{
   if (proxy == _profileProxy)
   {
      _profileProxy->sendDataChangedRegister(*this);
      _profileProxy->sendCopyProfileRegister(*this);
      _profileProxy->sendDeleteProfileRegister(*this);
      _profileProxy->sendCreateProfileRegister(*this);
      _profileProxy->sendDoRegisterAppRequest(*this, "SDS_ADAPTER");
   }
}


/**************************************************************************//**
 *
 ******************************************************************************/
void UserProfile::onCopyProfileError(const ::boost::shared_ptr< bosch::cm::profile::ProfileProxy >& /*proxy*/,
                                     const ::boost::shared_ptr< bosch::cm::profile::CopyProfileError >& /*error*/)
{
}


/**************************************************************************//**
 *
 ******************************************************************************/
void UserProfile::onCopyProfileUpdate(const ::boost::shared_ptr< bosch::cm::profile::ProfileProxy >& proxy,
                                      const ::boost::shared_ptr< bosch::cm::profile::CopyProfileUpdate >& /*update*/)
{
   if (proxy == _profileProxy)
   {
      _profileProxy->sendOnProfileCopiedRequest(_appID, clientResult__SUCCESS);
   }
}


/**************************************************************************//**
 *
 ******************************************************************************/
void UserProfile::onDeleteProfileError(const ::boost::shared_ptr< bosch::cm::profile::ProfileProxy >& /*proxy*/,
                                       const ::boost::shared_ptr< bosch::cm::profile::DeleteProfileError >& /*error*/)
{
}


/**************************************************************************//**
 *
 ******************************************************************************/
void UserProfile::onDeleteProfileUpdate(const ::boost::shared_ptr< bosch::cm::profile::ProfileProxy >& proxy,
                                        const ::boost::shared_ptr< bosch::cm::profile::DeleteProfileUpdate >& /*update*/)
{
   if (proxy == _profileProxy)
   {
      _profileProxy->sendOnProfileDeletedRequest(_appID, clientResult__SUCCESS);
   }
}


/**************************************************************************//**
 *
 ******************************************************************************/
void UserProfile::onDataChangedError(const ::boost::shared_ptr< bosch::cm::profile::ProfileProxy >& /*proxy*/,
                                     const ::boost::shared_ptr< bosch::cm::profile::DataChangedError >& /*error*/)
{
}


/**************************************************************************//**
 *
 ******************************************************************************/
void UserProfile::onDataChangedUpdate(const ::boost::shared_ptr< bosch::cm::profile::ProfileProxy >& proxy,
                                      const ::boost::shared_ptr< bosch::cm::profile::DataChangedUpdate >& update)
{
   ETG_TRACE_USR4(("UserProfile::onDataChangedUpdate %d", update->getDataChanged()));
   switch (update->getDataChanged())
   {
      case dataChangeReason__PREPARE:
         if (proxy == _profileProxy)
         {
            _profileProxy->sendOnDataChangedRequest(_appID, dataChangedResult__PREPARED);
         }
         break;
      case dataChangeReason__PROFILE_CHANGED:
         _systemVoiceSettings->getUserProfileData();
         if (proxy == _profileProxy)
         {
            _profileProxy->sendOnDataChangedRequest(_appID, dataChangedResult__PROFILE_CHANGED);
         }
         break;
      case dataChangeReason__IDLE:
         break;
      default:
         break;
   }
}


/**************************************************************************//**
 *
 ******************************************************************************/
void UserProfile::onCreateProfileError(const ::boost::shared_ptr< bosch::cm::profile::ProfileProxy >& /*proxy*/,
                                       const ::boost::shared_ptr< bosch::cm::profile::CreateProfileError >& /*error*/)
{
}


/**************************************************************************//**
 *
 ******************************************************************************/
void UserProfile::onCreateProfileUpdate(const ::boost::shared_ptr< bosch::cm::profile::ProfileProxy >& proxy,
                                        const ::boost::shared_ptr< bosch::cm::profile::CreateProfileUpdate >& /*update*/)
{
   if (proxy == _profileProxy)
   {
      _profileProxy->sendOnProfileCreatedRequest(_appID, clientResult__SUCCESS);
   }
}


/**************************************************************************//**
 *
 ******************************************************************************/
void UserProfile::onDoRegisterAppResponse(const ::boost::shared_ptr< bosch::cm::profile::ProfileProxy >& /*proxy*/,
      const ::boost::shared_ptr< bosch::cm::profile::DoRegisterAppResponse >& response)
{
   if (response->hasAppID())
   {
      _appID = response->getAppID();
   }
}


/**************************************************************************//**
 *
 ******************************************************************************/
void UserProfile::onDoRegisterAppError(const ::boost::shared_ptr< bosch::cm::profile::ProfileProxy >& /*proxy*/,
                                       const ::boost::shared_ptr< bosch::cm::profile::DoRegisterAppError >& /*error*/)
{
}
