/**************************************************************************//**
 * \file       SxmDataServicesObserver.h
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/

#ifndef SxmDataServicesObserver_h
#define SxmDataServicesObserver_h

#include <map>
#include <string>
#include <vector>


#include "external/sds2hmi_fi.h"


class SxmDataServicesObserver
{
   public:
      SxmDataServicesObserver();
      virtual ~SxmDataServicesObserver();
      virtual void notifyInfoMenuServiceStatus(
         const std::map<sds2hmi_fi_tcl_e8_Info_SXM_Services::tenType, sds2hmi_fi_tcl_e8_Info_Menu_Srvc_Status::tenType>& infoMap) = 0;
};


#endif
