/**************************************************************************//**
 * \file       SxmDataServices.h
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef SxmDataServices_h
#define SxmDataServices_h

#include "external/sds2hmi_fi.h"
#include "sxm_audio_main_fiProxy.h"
#include "sxm_canadian_fuel_main_fiProxy.h"
#include "sxm_fuel_main_fiProxy.h"
#include "sxm_parking_main_fiProxy.h"
#include "sxm_movies_main_fiProxy.h"
#include "sxm_sports_main_fiProxy.h"
#include "sxm_stocks_main_fiProxy.h"
#include "sxm_tabweather_main_fiProxy.h"
#include "org/bosch/cm/navigation/NavigationSDSServiceProxy.h"

class SxmDataServicesObserver;

class SxmDataServices:
   public asf::core::ServiceAvailableIF
   , public sxm_audio_main_fi::SxmDiagSignalQualityCallbackIF
   , public sxm_audio_main_fi::SxmDataServiceStatusCallbackIF
   , public sxm_audio_main_fi::SxmDataServiceAntennaStatusCallbackIF
   , public sxm_canadian_fuel_main_fi::CanadianFuelInfoListsStatusCallbackIF
   , public sxm_fuel_main_fi::FuelInfoListsStatusCallbackIF
   , public sxm_parking_main_fi::ParkingInfoListsStatusCallbackIF
   , public sxm_movies_main_fi::TheatreListsStatusCallbackIF
   , public sxm_sports_main_fi::SportsServiceDataStatusCallbackIF
   , public sxm_stocks_main_fi::StockStatusCallbackIF
   , public sxm_tabweather_main_fi::TabWeatherInfoListStatusCallbackIF
   , public org::bosch::cm::navigation::NavigationSDSService::PositionStatusInfoCallbackIF

{
   public:

      virtual ~SxmDataServices();
      SxmDataServices(
         boost::shared_ptr< sxm_audio_main_fi::Sxm_audio_main_fiProxy > sxmAudioProxy,
         boost::shared_ptr< sxm_canadian_fuel_main_fi::Sxm_canadian_fuel_main_fiProxy > sxmCanadianFuelProxy,
         boost::shared_ptr< sxm_fuel_main_fi::Sxm_fuel_main_fiProxy > sxmFuelProxy,
         boost::shared_ptr< sxm_parking_main_fi::Sxm_parking_main_fiProxy > sxmParkingProxy,
         boost::shared_ptr< sxm_movies_main_fi::Sxm_movies_main_fiProxy > sxmMovieProxy,
         boost::shared_ptr< sxm_sports_main_fi::Sxm_sports_main_fiProxy > sxmSportsProxy,
         boost::shared_ptr< sxm_stocks_main_fi::Sxm_stocks_main_fiProxy > sxmStocksProxy,
         boost::shared_ptr< sxm_tabweather_main_fi::Sxm_tabweather_main_fiProxy > sxmTabWeatherProxy,
         boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy > naviSDSProxy);

      void onAvailable(
         const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange);
      void onUnavailable(
         const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange);

      virtual void onSxmDiagSignalQualityError(
         const ::boost::shared_ptr< sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
         const ::boost::shared_ptr<sxm_audio_main_fi:: SxmDiagSignalQualityError >& error);

      virtual void onSxmDiagSignalQualityStatus(
         const ::boost::shared_ptr< sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
         const ::boost::shared_ptr< sxm_audio_main_fi::SxmDiagSignalQualityStatus >& status);

      virtual void onSxmDataServiceStatusError(
         const ::boost::shared_ptr< sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
         const ::boost::shared_ptr< sxm_audio_main_fi::SxmDataServiceStatusError >& error);

      virtual void onSxmDataServiceStatusStatus(
         const ::boost::shared_ptr< sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
         const ::boost::shared_ptr<sxm_audio_main_fi:: SxmDataServiceStatusStatus >& status);

      virtual void onSxmDataServiceAntennaStatusError(
         const ::boost::shared_ptr< sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
         const ::boost::shared_ptr< sxm_audio_main_fi::SxmDataServiceAntennaStatusError >& error);

      virtual void onSxmDataServiceAntennaStatusStatus(
         const ::boost::shared_ptr< sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
         const ::boost::shared_ptr< sxm_audio_main_fi::SxmDataServiceAntennaStatusStatus >& status);

      virtual void onCanadianFuelInfoListsStatusError(
         const ::boost::shared_ptr< sxm_canadian_fuel_main_fi::Sxm_canadian_fuel_main_fiProxy >& proxy,
         const ::boost::shared_ptr< sxm_canadian_fuel_main_fi::CanadianFuelInfoListsStatusError >& error);

      virtual void onCanadianFuelInfoListsStatusStatus(
         const ::boost::shared_ptr< sxm_canadian_fuel_main_fi::Sxm_canadian_fuel_main_fiProxy >& proxy,
         const ::boost::shared_ptr< sxm_canadian_fuel_main_fi::CanadianFuelInfoListsStatusStatus >& status);

      virtual void onFuelInfoListsStatusError(
         const ::boost::shared_ptr< sxm_fuel_main_fi::Sxm_fuel_main_fiProxy >& proxy,
         const ::boost::shared_ptr< sxm_fuel_main_fi::FuelInfoListsStatusError >& error);

      virtual void onFuelInfoListsStatusStatus(
         const ::boost::shared_ptr< sxm_fuel_main_fi::Sxm_fuel_main_fiProxy >& proxy,
         const ::boost::shared_ptr< sxm_fuel_main_fi::FuelInfoListsStatusStatus >& status);

      virtual void onParkingInfoListsStatusError(
         const ::boost::shared_ptr< sxm_parking_main_fi::Sxm_parking_main_fiProxy >& proxy,
         const ::boost::shared_ptr< sxm_parking_main_fi::ParkingInfoListsStatusError >& error);

      virtual void onParkingInfoListsStatusStatus(
         const ::boost::shared_ptr< sxm_parking_main_fi::Sxm_parking_main_fiProxy >& proxy,
         const ::boost::shared_ptr< sxm_parking_main_fi::ParkingInfoListsStatusStatus >& status);

      virtual void onSportsServiceDataStatusError(
         const ::boost::shared_ptr< sxm_sports_main_fi::Sxm_sports_main_fiProxy >& proxy,
         const ::boost::shared_ptr< sxm_sports_main_fi::SportsServiceDataStatusError >& error);

      virtual void onSportsServiceDataStatusStatus(
         const ::boost::shared_ptr< sxm_sports_main_fi::Sxm_sports_main_fiProxy >& proxy,
         const ::boost::shared_ptr< sxm_sports_main_fi::SportsServiceDataStatusStatus >& status);

      virtual void onStockStatusError(
         const ::boost::shared_ptr< sxm_stocks_main_fi::Sxm_stocks_main_fiProxy >& proxy,
         const ::boost::shared_ptr< sxm_stocks_main_fi::StockStatusError >& error);

      virtual void onStockStatusStatus(
         const ::boost::shared_ptr< sxm_stocks_main_fi::Sxm_stocks_main_fiProxy >& proxy,
         const ::boost::shared_ptr< sxm_stocks_main_fi::StockStatusStatus >& status);

      virtual void onTabWeatherInfoListStatusError(
         const ::boost::shared_ptr< sxm_tabweather_main_fi::Sxm_tabweather_main_fiProxy >& proxy,
         const ::boost::shared_ptr< sxm_tabweather_main_fi::TabWeatherInfoListStatusError >& error);

      virtual void onTabWeatherInfoListStatusStatus(
         const ::boost::shared_ptr< sxm_tabweather_main_fi::Sxm_tabweather_main_fiProxy >& proxy,
         const ::boost::shared_ptr< sxm_tabweather_main_fi::TabWeatherInfoListStatusStatus >& status);

      virtual void onTheatreListsStatusError(
         const ::boost::shared_ptr< sxm_movies_main_fi::Sxm_movies_main_fiProxy >& proxy,
         const ::boost::shared_ptr< sxm_movies_main_fi::TheatreListsStatusError >& error);

      virtual void onTheatreListsStatusStatus(
         const ::boost::shared_ptr< sxm_movies_main_fi::Sxm_movies_main_fiProxy >& proxy,
         const ::boost::shared_ptr< sxm_movies_main_fi::TheatreListsStatusStatus >& status);

      virtual void onPositionStatusInfoError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::PositionStatusInfoError >& error);

      virtual void onPositionStatusInfoUpdate(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::PositionStatusInfoUpdate >& update);

      void addSxmDataServiceObserver(SxmDataServicesObserver* pDataService);

   private:

      enum EnumSxmServiceAdvisoryStatus
      {
         ENUM_SXM_SERVICE_ADVISORY_STATUS_UNKNOWN = 1u,
         ENUM_SXM_SERVICE_ADVISORY_STATUS_SUBSCRIBED = 2u,
         ENUM_SXM_SERVICE_ADVISORY_STATUS_NOT_SUBSCRIBED = 3u,
         ENUM_SXM_SERVICE_ADVISORY_STATUS_NOT_AVAILABLE = 4u,
         ENUM_SXM_SERVICE_ADVISORY_STATUS_CHECK_ANTENNA = 5u,
         ENUM_SXM_SERVICE_ADVISORY_STATUS_NO_SIGNAL  = 6u ,
         ENUM_SXM_SERVICE_ADVISORY_STATUS_READY_NO_SIGNAL = 7u
      };

      enum EnumSxmDataListStatus
      {
         ENUM_SXM_DATA_LIST_STATUS_UNKNOWN = 1u,
         ENUM_SXM_DATA_LIST_STATUS_READY = 2u ,
         ENUM_SXM_DATA_LIST_STATUS_UPDATING = 3u,
         ENUM_SXM_DATA_LIST_STATUS_INVAILD = 4u,
         ENUM_SXM_DATA_LIST_STATUS_ERROR = 5u
      };

      enum EnumCountryCode
      {
         Enum_COUNTRY_CODE_UNKNOWN = 0u,
         Enum_COUNTRY_CODE_USA = 1u,
         Enum_COUNTRY_CODE_CAN = 2u
      };

      void initializeAdvisoryStatus();
      void initializeListStatus();
      void notifyInfoMenuServiceStatus();

      EnumSxmServiceAdvisoryStatus getAdvisoryStatusOnRequestedServiceType(sxm_main_fi_types::T_e8_SxmDataServiceType enType)const;
      EnumSxmDataListStatus getListStatusOnRequestedServiceType(sxm_main_fi_types::T_e8_SxmDataServiceType enType)const;
      EnumSxmDataListStatus getSxmDataListStatus(sxm_main_fi_types::T_e8_SxmListStatus enStatus)const;
      EnumSxmServiceAdvisoryStatus getAdvisoryStatusOnSxmDataService(sxm_main_fi_types::T_e8_SxmDataServiceStatus serviceStatus)const;
      EnumSxmDataListStatus getSxmTabWeatherAreMovieListstatus(
         const std::map < sxm_main_fi_types::T_e8_SxmListType,
         sxm_main_fi_types::T_e8_SxmListStatus >& sxmListReady)const;

      sds2hmi_fi_tcl_e8_Info_Menu_Srvc_Status::tenType getInfoMenuServiceStatus(
         sxm_main_fi_types::T_e8_SxmDataServiceType enType)const;

      void updateSdsInfoMenuSxmServiceType(sxm_main_fi_types::T_e8_SxmDataServiceType enType);
      void updateFuelService();
      void updateTabWeatherService();
      bool isSxmServiceValidInInformationDomain(sxm_main_fi_types::T_e8_SxmDataServiceType enType);
      void onSxmAntennaAndSignalChangeStatus();

      std::map<sxm_main_fi_types::T_e8_SxmDataServiceType, EnumSxmServiceAdvisoryStatus> _advisoryStatusMap;
      std::map<sxm_main_fi_types::T_e8_SxmDataServiceType, EnumSxmDataListStatus> _listStatusMap;
      std::map<sds2hmi_fi_tcl_e8_Info_SXM_Services::tenType, sds2hmi_fi_tcl_e8_Info_Menu_Srvc_Status::tenType> _sdsInfoSxmServiceMap;

      boost::shared_ptr< sxm_audio_main_fi::Sxm_audio_main_fiProxy > _sxmAudioProxy;
      boost::shared_ptr< sxm_canadian_fuel_main_fi::Sxm_canadian_fuel_main_fiProxy > _sxmCanadianFuelProxy;
      boost::shared_ptr< sxm_fuel_main_fi::Sxm_fuel_main_fiProxy > _sxmFuelProxy;
      boost::shared_ptr< sxm_parking_main_fi::Sxm_parking_main_fiProxy > _sxmParkingProxy;
      boost::shared_ptr< sxm_movies_main_fi::Sxm_movies_main_fiProxy > _sxmMovieProxy;
      boost::shared_ptr< sxm_sports_main_fi::Sxm_sports_main_fiProxy > _sxmSportsProxy;
      boost::shared_ptr< sxm_stocks_main_fi::Sxm_stocks_main_fiProxy > _sxmStocksProxy;
      boost::shared_ptr< sxm_tabweather_main_fi::Sxm_tabweather_main_fiProxy > _sxmTabWeatherProxy;
      boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy > _naviSDSProxy;

      SxmDataServicesObserver* _pDataService;
      bool _isSxmSignalStatus;
      bool _issxmAntennaStatus;
      EnumCountryCode _currentCountryCode;
};


#endif
