/**************************************************************************//**
 * \file       SdsPhoneService.cpp
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/

#include "application/SdsPhoneService.h"
#include "application/clSDS_Userwords.h"

using namespace sds_gui_fi::SdsPhoneService;

/**************************************************************************//**
* Constructor
******************************************************************************/
SdsPhoneService::SdsPhoneService(clSDS_Userwords* pUserWords)
   : SdsPhoneServiceStub("SdsPhoneServicePort")
   , _pUserWords(pUserWords)

{
}


/**************************************************************************//**
* Destructor
******************************************************************************/
SdsPhoneService::~SdsPhoneService()
{
   _pUserWords = NULL;
}


/**************************************************************************//**
*
******************************************************************************/
void SdsPhoneService::onVoiceTagActionRequest(const ::boost::shared_ptr< VoiceTagActionRequest >& request)
{
   if (_pUserWords != NULL)
   {
      _pUserWords->handleUserWordActions(request);
   }
}
