/**************************************************************************//**
 * \file       SdsDataHandoverService.h
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/

#ifndef SdsDataHandoverService_h
#define SdsDataHandoverService_h

#include "sds_gui_fi/SdsDataHandoverServiceStub.h"

class DataHandoverServiceObserver;

class SdsDataHandoverService : public sds_gui_fi::SdsDataHandoverService::SdsDataHandoverServiceStub
{
   public:
      SdsDataHandoverService();
      virtual ~SdsDataHandoverService();
      virtual void onDataHandoverRequest(const ::boost::shared_ptr< sds_gui_fi::SdsDataHandoverService::DataHandoverRequest >& request);
      void addDataHandoverObserver(DataHandoverServiceObserver* obs);
      void notifyDialedDataReceived(std::string dialedDigits);
      void sendDialDigitsHandoverRequest(bool requestStatus);

   private:
      std::vector<DataHandoverServiceObserver*> _pdataHandoverObserver;
};


#endif
