/**************************************************************************//**
 * \file       SdsDataHandoverService.cpp
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/

#include "application/SdsDataHandoverService.h"
#include "application/DataHandoverServiceObserver.h"

#include "SdsAdapter_Trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SDSADP_DETAILS
#include "trcGenProj/Header/SdsDataHandoverService.cpp.trc.h"
#endif


using namespace sds_gui_fi::SdsDataHandoverService;
/**************************************************************************//**
* Constructor
******************************************************************************/
SdsDataHandoverService::SdsDataHandoverService()
   : SdsDataHandoverServiceStub("SdsDataHandoverServicePort")

{
}


/**************************************************************************//**
* Destructor
******************************************************************************/
SdsDataHandoverService::~SdsDataHandoverService()
{
   for (size_t obsIndex = 0; obsIndex != _pdataHandoverObserver.size(); ++obsIndex)
   {
      _pdataHandoverObserver[obsIndex] = NULL;
   }
}


/**************************************************************************//**
*
******************************************************************************/
void SdsDataHandoverService::onDataHandoverRequest(const ::boost::shared_ptr< DataHandoverRequest >& request)
{
   ETG_TRACE_USR4(("onDataHandoverRequest: ScreenType = %d, ScreenState = %d", request->getScreenType(), request->getScreenState()));
   bool isScreenactive = (request->getScreenState() == ScreenState__ENTRY || request->getScreenState() == ScreenState__ACTIVE_ON_PTT) ? true : false;

   for (size_t obsIndex = 0; obsIndex != _pdataHandoverObserver.size(); ++obsIndex)
   {
      if (_pdataHandoverObserver[obsIndex] != NULL)
      {
         _pdataHandoverObserver[obsIndex]->phoneDataHandoverScreenChanged(isScreenactive);
      }
   }

   if (request->getScreenState() == ScreenState__ACTIVE_ON_PTT)
   {
      switch (request->getScreenType())
      {
         case ScreenType__PHONE_DIAL_NUMBER :
            notifyDialedDataReceived(request->getData());
            setSendHandoverData(false);
            break;
         case ScreenType__INVALID :
         default :
            break;
      }
   }
}


/**************************************************************************//**
*
******************************************************************************/
void SdsDataHandoverService::sendDialDigitsHandoverRequest(bool requestStatus)
{
   setSendHandoverData(requestStatus);
}


/**************************************************************************//**
*
******************************************************************************/
void SdsDataHandoverService::addDataHandoverObserver(DataHandoverServiceObserver* obs)
{
   if (obs != NULL)
   {
      _pdataHandoverObserver.push_back(obs);
   }
}


/**************************************************************************//**
*
******************************************************************************/
void SdsDataHandoverService::notifyDialedDataReceived(std::string dialedDigits)
{
   for (size_t obsIndex = 0; obsIndex != _pdataHandoverObserver.size(); ++obsIndex)
   {
      if (_pdataHandoverObserver[obsIndex] != NULL)
      {
         _pdataHandoverObserver[obsIndex]->handleDialNumberDataHandover(dialedDigits);
      }
   }
}
