/**************************************************************************//**
 * \file       PhonebookContacts.h
 *
 * List Phonebook functions
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/

#ifndef PhonebookContacts_h
#define PhonebookContacts_h

#include "external/sds2hmi_fi.h"
#include "MOST_PhonBk_FIProxy.h"
#include "MOST_Tel_FIProxy.h"

class PhonebookObserver;

class PhonebookContacts
   : public asf::core::ServiceAvailableIF
   , public MOST_PhonBk_FI::CreateContactListCallbackIF
   , public MOST_PhonBk_FI::RequestPhoneBookListSliceCallbackIF
   , public MOST_PhonBk_FI::GetContactDetailsExtendedCallbackIF
   , public MOST_PhonBk_FI::PreferredPhoneBookSortOrderCallbackIF
{
   public:
      PhonebookContacts(boost::shared_ptr<MOST_PhonBk_FI::MOST_PhonBk_FIProxy> phonebookProxy,
                        boost::shared_ptr< MOST_Tel_FI::MOST_Tel_FIProxy > telephoneProxy);
      virtual ~PhonebookContacts();

      virtual void onAvailable(
         const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange);
      virtual void onUnavailable(
         const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange);

      virtual void onCreateContactListError(
         const ::boost::shared_ptr< MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& proxy,
         const ::boost::shared_ptr< MOST_PhonBk_FI::CreateContactListError >& error);
      virtual void onCreateContactListResult(
         const ::boost::shared_ptr< MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& proxy,
         const ::boost::shared_ptr< MOST_PhonBk_FI::CreateContactListResult >& result);

      virtual void onRequestPhoneBookListSliceError(
         const ::boost::shared_ptr< MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& proxy,
         const ::boost::shared_ptr< MOST_PhonBk_FI::RequestPhoneBookListSliceError >& error);
      virtual void onRequestPhoneBookListSliceResult(
         const ::boost::shared_ptr< MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& proxy,
         const ::boost::shared_ptr< MOST_PhonBk_FI::RequestPhoneBookListSliceResult >& result);

      virtual void onPreferredPhoneBookSortOrderError(
         const ::boost::shared_ptr< MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& proxy,
         const ::boost::shared_ptr< MOST_PhonBk_FI::PreferredPhoneBookSortOrderError >& error);
      virtual void onPreferredPhoneBookSortOrderStatus(
         const ::boost::shared_ptr< MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& proxy,
         const ::boost::shared_ptr< MOST_PhonBk_FI::PreferredPhoneBookSortOrderStatus >& status);

      virtual void onGetContactDetailsExtendedError(
         const ::boost::shared_ptr< MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& proxy,
         const ::boost::shared_ptr< MOST_PhonBk_FI::GetContactDetailsExtendedError >& error);

      virtual void onGetContactDetailsExtendedResult(
         const ::boost::shared_ptr< MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& proxy,
         const ::boost::shared_ptr< MOST_PhonBk_FI::GetContactDetailsExtendedResult >& result);

      void retrieveContactsList(sds2hmi_fi_tcl_e8_HMI_ListType::tenType hmiListType);
      void getContactNumbers();
      std::string getContactNumber(unsigned int selectedIndex);
      void registerObserver(PhonebookObserver* obs);
      void setSelectedIndex(unsigned int selectedIndex);
      unsigned int getSelectedIndex();

   private:
      void notifyContactListObserver();
      void notifyContactDetailsObserver();

      std::string getContactName(most_PhonBk_fi_types::T_PhonBkPhoneBookListSliceResultItem contactDetails) const;
      std::vector<std::string> getContactsNames();
      std::vector<std::pair <std::string, unsigned int> > getContactDetails();
      void addNewContact(std::vector<std::pair <std::string, unsigned int> >& contactNumberDetails, std::pair <std::string, unsigned int>& contactNumber);
      most_PhonBk_fi_types_Extended::T_e8_PhonBkContactSortType getPhonebookListSortType(sds2hmi_fi_tcl_e8_HMI_ListType::tenType hmiListType);
      most_PhonBk_fi_types_Extended::T_e8_PhonBkContactListType getPhonebookListType(sds2hmi_fi_tcl_e8_HMI_ListType::tenType hmiListType);

      boost::shared_ptr<MOST_PhonBk_FI::MOST_PhonBk_FIProxy> _phonebookProxy;
      std::vector< most_PhonBk_fi_types::T_PhonBkPhoneBookListSliceResultItem > _contactsList;
      most_PhonBk_fi_types_Extended::T_PhonBkContactDetailsExtended _contactDetails;
      std::vector<PhonebookObserver*> _phonebookObservers;
      unsigned int _selectedIndex;
      enum enPhoneNumberType
      {
         EN_PREFFERED,
         EN_HOME_1,
         EN_HOME_2,
         EN_WORK_1,
         EN_WORK_2,
         EN_CELL_1,
         EN_CELL_2,
         EN_OTHERS
      };
      enPhoneNumberType getPhoneNumberType(most_PhonBk_fi_types_Extended::T_e8_PhonBkNumberType numberType);
      boost::shared_ptr< MOST_Tel_FI::MOST_Tel_FIProxy > _telephoneProxy;
};


#endif
