/**************************************************************************//**
 * \file       NdsStringRequestor.h
 *
 * NdsStringRequestor (AIF)
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef NdsStringRequestor_h
#define NdsStringRequestor_h


#include "external/sds2hmi_fi.h"
#include "asf/core/Proxy.h"
#include "org/bosch/cm/navigation/NavigationSDSServiceProxy.h"
#include <vector>
#include <string>


class NdsStringObserver;


class NdsStringRequestor
   : public org::bosch::cm::navigation::NavigationSDSService::GetNamesForNDSIdsCallbackIF
{
   public:
      virtual ~NdsStringRequestor();
      NdsStringRequestor(
         ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy > naviProxy);

      // callbacks by GetNamesForNDSIdsCallbackIF
      virtual void onGetNamesForNDSIdsError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::GetNamesForNDSIdsError >& error);
      virtual void onGetNamesForNDSIdsResponse(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::GetNamesForNDSIdsResponse >& getNamesForNDSIdsResponse);

      void addNdsStringObserver(NdsStringObserver* pObserver);
      void getNdsFeautreType(
         std::vector<sds2hmi_fi_tcl_NDSID> ndsIdString,
         std::vector<sds2hmi_fi_tcl_NDSLanguageID> ndsLanguageId);
      void getNdsNamedObjectList(std::vector< org::bosch::cm::navigation::NavigationSDSService::NamedObjectIdStrings >& namedObjectList);
      void getNdsPOINameList(std::vector< org::bosch::cm::navigation::NavigationSDSService::NamedObjectIdStrings >& poiNameList);
      void getNdsPOICategoryList(std::vector< org::bosch::cm::navigation::NavigationSDSService::NamedObjectIdStrings >& poiCategoryList);
      void getNdsPOIAttributeList(std::vector< org::bosch::cm::navigation::NavigationSDSService::NamedObjectIdStrings >& poiAttributeList);
      void clearAllListData();

   private:

      void getNdsIdBasedOnFeatureType(
         sds2hmi_fi_tcl_NDSID ndsIdObject,
         std::vector<sds2hmi_fi_tcl_NDSID>& ndsObjectIdList);
      void updateSDSRequestedFeatureType();
      void getStringForNdsId();
      void sendNdsIdStringRequest(
         std::vector<sds2hmi_fi_tcl_NDSID>& objectIdList,
         org::bosch::cm::navigation::NavigationSDSService::NDSFeatureType ndsFeatureType);
      void getLanguageListEntry(std::vector< org::bosch::cm::navigation::NavigationSDSService::LanguageEntry >& languageEntryList);
      void notifyObjectIdStringListObservers();

      boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy > _navigationSDSProxy;

      std::vector<sds2hmi_fi_tcl_NDSID> _sdsNamedObjectList;
      std::vector<sds2hmi_fi_tcl_NDSID> _sdsPOICategoryList;
      std::vector<sds2hmi_fi_tcl_NDSID> _sdsPOIBrandNameList;
      std::vector<sds2hmi_fi_tcl_NDSID> _sdsPOINameList;

      std::vector< org::bosch::cm::navigation::NavigationSDSService::NamedObjectIdStrings > _ndsStringNamedObject;
      std::vector< org::bosch::cm::navigation::NavigationSDSService::NamedObjectIdStrings > _ndsStringPOIName;
      std::vector< org::bosch::cm::navigation::NavigationSDSService::NamedObjectIdStrings > _ndsStringPOICategory;
      std::vector< org::bosch::cm::navigation::NavigationSDSService::NamedObjectIdStrings > _ndsStringPOIAttribute;

      std::vector<NdsStringObserver*> _ndsStringObservers;

      std::vector<sds2hmi_fi_tcl_NDSLanguageID> _sdsNdsLanguageId;
      sds2hmi_fi_tcl_e8_NDSFeatureType _currentRequestedFeatureType;
      tU32 _featureTypeRequestCounter;
};


#endif
