/**************************************************************************//**
 * \file       NaviPOIIconsList.h
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef NaviPOIIconsList_h
#define NaviPOIIconsList_h


#include <string>
#include <vector>
#include "org/bosch/cm/navigation/NavigationSDSServiceProxy.h"
#include "application/GuiService.h"
#include "application/clSDS_List.h"
#include "external/sds2hmi_fi.h"


class clSDS_Property_NaviPOIIconList;


class NaviPOIIconsList
   : public clSDS_List
   , public asf::core::ServiceAvailableIF
   , public org::bosch::cm::navigation::NavigationSDSService::GetDynamicPoiIconCategoriesInMapCallbackIF
   , public org::bosch::cm::navigation::NavigationSDSService::SetDynamicPoiIconCategoriesInMapCallbackIF
   , public org::bosch::cm::navigation::NavigationSDSService::DynamicMapPoiCategoryWithLanguageCallbackIF
{
   public:
      NaviPOIIconsList(
         GuiService* guiService,
         ::boost::shared_ptr<org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy> pNaviSDSProxy,
         clSDS_Property_NaviPOIIconList* pclSDSPropertyNaviPOIIconList);

      virtual ~NaviPOIIconsList();

      void onUnavailable(
         const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange);

      void onAvailable(
         const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange);

      virtual void onGetDynamicPoiIconCategoriesInMapError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::GetDynamicPoiIconCategoriesInMapError >& error);

      virtual void onGetDynamicPoiIconCategoriesInMapResponse(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::GetDynamicPoiIconCategoriesInMapResponse >& response);

      virtual void onSetDynamicPoiIconCategoriesInMapError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::SetDynamicPoiIconCategoriesInMapError >& error);

      virtual void onSetDynamicPoiIconCategoriesInMapResponse(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::SetDynamicPoiIconCategoriesInMapResponse >& response);

      void onDynamicMapPoiCategoryWithLanguageUpdate(const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy >& proxy, const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::DynamicMapPoiCategoryWithLanguageUpdate >& update);
      void onDynamicMapPoiCategoryWithLanguageError(const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy >& proxy, const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::DynamicMapPoiCategoryWithLanguageError >& error);

      ::std::vector< org::bosch::cm::navigation::NavigationSDSService::DynamicMapPoiCategory > _dynamicMapPOICategory;

      org::bosch::cm::navigation::NavigationSDSService::LanguageEntry _languageEntry;
      void sendGetDynamicPOIIconCategoriesRequest(sds2hmi_fi_tcl_Nav_IconSetting requestedAction);
      sds2hmi_fi_tcl_e16_ISOCountryCode::tenType convertNaviStringtoISOCountryCode(const std::string& countryCode);
      sds2hmi_fi_tcl_e16_ISO639_3_SDSLanguageCode::tenType convertNaviStringtoISOLanguageCode(const std::string& languageCode);

   private:
      virtual tVoid vGetListInfo(sds2hmi_fi_tcl_e8_HMI_ListType::tenType listType) {};
      virtual tU32 u32GetSize();
      virtual std::vector<clSDS_ListItems> oGetItems(tU32 u32StartIndex, tU32 u32EndIndex);
      virtual tBool bSelectElement(tU32 u32SelectedIndex);
      std::string oGetItem(tU32 u32Index);
      std::vector<sds2hmi_fi_tcl_HMIElementDescription> getHmiElementDescription(unsigned int index);
      std::vector<sds2hmi_fi_tcl_HMIElementDescrptionList> getHmiListDescription();

      void handlePOIIconRequest(sds2hmi_fi_tcl_Nav_IconSetting oNavIconSettings);
      void sendShowOrRemoveallPOIIconRequest(bool poiIconShowStatus);
      void setNaviPOIIconCategory(const std::string selectioncriteriontype, bool status);
      void handleDynamicMapPoiCategoriesWithLanguage();
      sds2hmi_fi_tcl_NDSID getDestinationIdList(org::bosch::cm::navigation::NavigationSDSService::GlobalNamedObjectId nameObjectId);

      GuiService* _pGuiService;
      boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy > _naviSDSProxy;
      clSDS_Property_NaviPOIIconList* _pclSDSPropertyNaviPOIIconList;

      bool _showIcon;
      bool _removeIcon;
      bool _showRemoveRequested;
      sds2hmi_fi_tcl_Nav_IconSetting _requestedDisplayAction;
};


#endif
