/**************************************************************************//**
 * \file       NaviHapticHandOverList.h
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2017 Robert Bosch GmbH
 *             (C) 2017 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef NaviHapticHandOverList_h
#define NaviHapticHandOverList_h


#include "org/bosch/cm/navigation/NavigationSDSServiceProxy.h"
#include "application/clSDS_List.h"
#include <string>
#include <vector>


class NaviHapticHandOverList : public clSDS_List
{
   public:
      NaviHapticHandOverList();
      virtual ~NaviHapticHandOverList();

      tVoid vGetListInfo(sds2hmi_fi_tcl_e8_HMI_ListType::tenType listType);
      tU32 u32GetSize();
      std::vector<clSDS_ListItems> oGetItems(tU32 u32StartIndex, tU32 u32EndIndex);
      tBool bSelectElement(tU32 u32SelectedIndex);
      void setHandOverHMIList(const std::vector<std::string>& oHMIList, const std::vector<std::string>& dataList, const std::vector<sds2hmi_fi_tcl_NDSID>& destinationIDList, sds2hmi_fi_tcl_e8_SDS_EntryPoint::tenType sdsScreen);

   private:
      std::string oGetItem(tU32 u32Index);
      std::vector<sds2hmi_fi_tcl_HMIElementDescription>  getHmiElementDescription(unsigned int index);
      std::vector<std::string> _dataList;
      std::vector<std::string> _HMIList;
      std::vector<sds2hmi_fi_tcl_NDSID> _destinationIdList;
      uint32 _selectedIndex;
      sds2hmi_fi_tcl_e8_SDS_EntryPoint::tenType _hmiScreen;
};


#endif
