/**************************************************************************//**
 * \file       NaviHapticHandOverList.cpp
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2017 Robert Bosch GmbH
 *             (C) 2017 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#include "application/NaviHapticHandOverList.h"


NaviHapticHandOverList::NaviHapticHandOverList():
   _selectedIndex(0),
   _hmiScreen(sds2hmi_fi_tcl_e8_SDS_EntryPoint::FI_EN_SDS_ENTRY_GLOBAL)
{
}


NaviHapticHandOverList::~NaviHapticHandOverList()
{
}


tVoid NaviHapticHandOverList::vGetListInfo(sds2hmi_fi_tcl_e8_HMI_ListType::tenType listType)
{
   notifyListObserver();
}


tU32 NaviHapticHandOverList::u32GetSize()
{
   return _HMIList.size();
}


std::string NaviHapticHandOverList::oGetItem(tU32 u32Index)
{
   if (u32Index < _HMIList.size())
   {
      return _HMIList[u32Index];
   }
   else
   {
      return "";
   }
}


std::vector<clSDS_ListItems> NaviHapticHandOverList::oGetItems(tU32 u32StartIndex, tU32 u32EndIndex)
{
   std::vector<clSDS_ListItems> oListItems;
   for (tU32 u32Index = u32StartIndex; u32Index < std::min(u32EndIndex, u32GetSize()); u32Index++)
   {
      clSDS_ListItems oListItem;
      oListItem.oDescription.szString = oGetItem(u32Index);
      oListItem.oDirectionSymbol.szString = NO_ICON;
      oListItem.oDistance.szString = " ";
      oListItems.push_back(oListItem);
   }
   return oListItems;
}


tBool NaviHapticHandOverList::bSelectElement(tU32 u32SelectedIndex)
{
   if (u32SelectedIndex > 0)
   {
      _selectedIndex = u32SelectedIndex - 1;
      return true;
   }
   return false;
}


void NaviHapticHandOverList::setHandOverHMIList(const std::vector<std::string>& oHMIList, const std::vector<std::string>& dataList, const std::vector<sds2hmi_fi_tcl_NDSID>& destinationIdList, sds2hmi_fi_tcl_e8_SDS_EntryPoint::tenType sdsScreen)
{
   _HMIList.clear();
   _destinationIdList.clear();
   _dataList.clear();
   _HMIList = oHMIList;
   _dataList = dataList;
   _destinationIdList = destinationIdList;
   _hmiScreen = sdsScreen;
}


std::vector<sds2hmi_fi_tcl_HMIElementDescription>  NaviHapticHandOverList::getHmiElementDescription(unsigned int index)
{
   sds2hmi_fi_tcl_HMIElementDescription hmiElementDescription;
   std::vector<sds2hmi_fi_tcl_HMIElementDescription> hmiElementDescriptionList;
   hmiElementDescriptionList.clear();
   if (!_HMIList.empty())
   {
      switch (_hmiScreen)
      {
         case sds2hmi_fi_tcl_e8_SDS_EntryPoint::FI_EN_SDS_ENTRY_NAVI_ADDRS_STEP_ENTER_STATE:
         {
            hmiElementDescription.DescriptorTag.enType = sds2hmi_fi_tcl_e8_WordType::FI_EN_STATE;
            break;
         }
         case sds2hmi_fi_tcl_e8_SDS_EntryPoint::FI_EN_SDS_ENTRY_NAVI_ADDRS_STEP_HNOFIRST_STREET_CITY:
         {
            hmiElementDescription.DescriptorTag.enType = sds2hmi_fi_tcl_e8_WordType::FI_EN_CITY;
            break;
         }
         case sds2hmi_fi_tcl_e8_SDS_EntryPoint::FI_EN_SDS_ENTRY_NAVI_STEP_CITYFIRST_CITY:
         {
            hmiElementDescription.DescriptorTag.enType = sds2hmi_fi_tcl_e8_WordType::FI_EN_CITY;
            break;
         }
         case sds2hmi_fi_tcl_e8_SDS_EntryPoint::FI_EN_SDS_ENTRY_NAVI_STEP_CITYFIRST_HNO_STREET:
         {
            hmiElementDescription.DescriptorTag.enType = sds2hmi_fi_tcl_e8_WordType::FI_EN_STREET;
            break;
         }
         case sds2hmi_fi_tcl_e8_SDS_EntryPoint::FI_EN_SDS_ENTRY_NAVI_ADDRS_STEP_CITYFIRST_STREET:
         {
            hmiElementDescription.DescriptorTag.enType = sds2hmi_fi_tcl_e8_WordType::FI_EN_STREET;
            break;
         }
         case sds2hmi_fi_tcl_e8_SDS_EntryPoint::FI_EN_SDS_ENTRY_NAVI_CITYCENTER_CITY:
         {
            hmiElementDescription.DescriptorTag.enType = sds2hmi_fi_tcl_e8_WordType::FI_EN_CITY;
            break;
         }
         case sds2hmi_fi_tcl_e8_SDS_EntryPoint::FI_EN_SDS_ENTRY_NAVI_CITYCENTER_STEP_ENTER_STATE:
         {
            hmiElementDescription.DescriptorTag.enType = sds2hmi_fi_tcl_e8_WordType::FI_EN_STATE;
            break;
         }
         case sds2hmi_fi_tcl_e8_SDS_EntryPoint::FI_EN_SDS_ENTRY_NAVI_INTERSECTION_STRT1:
         {
            hmiElementDescription.DescriptorTag.enType = sds2hmi_fi_tcl_e8_WordType::FI_EN_STREET;
            break;
         }
         case sds2hmi_fi_tcl_e8_SDS_EntryPoint::FI_EN_SDS_ENTRY_NAVI_INTERSECTION_STRT2:
         {
            hmiElementDescription.DescriptorTag.enType = sds2hmi_fi_tcl_e8_WordType::FI_EN_STREET2;
            break;
         }
         case sds2hmi_fi_tcl_e8_SDS_EntryPoint::FI_EN_SDS_ENTRY_NAVI_INTERSECT_STEP_ENTER_STATE:
         {
            hmiElementDescription.DescriptorTag.enType = sds2hmi_fi_tcl_e8_WordType::FI_EN_STATE;
            break;
         }
         case sds2hmi_fi_tcl_e8_SDS_EntryPoint::FI_EN_SDS_ENTRY_NAVI_INTERSECT_STEP_ENTER_CITY:
         {
            hmiElementDescription.DescriptorTag.enType = sds2hmi_fi_tcl_e8_WordType::FI_EN_CITY;
            break;
         }
         case sds2hmi_fi_tcl_e8_SDS_EntryPoint::FI_EN_SDS_ENTRY_NAVI_SET_DEST_POI:
         {
            hmiElementDescription.DescriptorTag.enType = sds2hmi_fi_tcl_e8_WordType::FI_EN_POINAME;
            break;
         }
         case sds2hmi_fi_tcl_e8_SDS_EntryPoint::FI_EN_SDS_ENTRY_NAVI_POI_IN_CITY:
         {
            hmiElementDescription.DescriptorTag.enType = sds2hmi_fi_tcl_e8_WordType::FI_EN_CITY;
            break;
         }
         case sds2hmi_fi_tcl_e8_SDS_EntryPoint::FI_EN_SDS_ENTRY_NAVI_POI_STEP_ENTER_STATE:
         {
            hmiElementDescription.DescriptorTag.enType = sds2hmi_fi_tcl_e8_WordType::FI_EN_STATE;
            break;
         }

         default:
            break;
      }

      hmiElementDescription.DescriptorValue.bSet(_HMIList.at(index - 1).c_str(), sds2hmi_fi_tclString::FI_EN_UTF8);
      std::vector<sds2hmi_fi_tcl_NDSID> destinationIdList;
      for (size_t i = 0; i < _dataList.size(); ++i)
      {
         if (_HMIList[index - 1] == _dataList[i])
         {
            destinationIdList.push_back(_destinationIdList[i]);
         }
      }
      hmiElementDescription.DestinationIdList = destinationIdList;
      hmiElementDescriptionList.push_back(hmiElementDescription);
   }
   return hmiElementDescriptionList;
}
