/**************************************************************************//**
 * \file       NaviHapticHandOverInterface.h
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2017 Robert Bosch GmbH
 *             (C) 2017 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef NaviHapticHandOverInterface_h
#define NaviHapticHandOverInterface_h


#include "org/bosch/cm/navigation/NavigationSDSServiceProxy.h"
#include "org/bosch/cm/navigation/NavigationService.h"
#include "application/clSDS_ConfigurationFlags.h"
#include "external/sds2hmi_fi.h"
#include "application/clSDS_SdsControl.h"
#include "application/clSDS_KDSConfiguration.h"


class clSDS_Property_CommonActionRequest;
class clSDS_POIList;
class clSDS_MultipleDestinationsList;
class NaviPOICategoryList;
class NaviHapticHandOverList;
class clSDS_NaviListItems;


class NaviHapticHandOverInterface :
   public asf::core::ServiceAvailableIF
   , public org::bosch::cm::navigation::NavigationSDSService::GetHapticHandOverDataCallbackIF
   , public org::bosch::cm::navigation::NavigationSDSService::HandOverSessionStatusCallbackIF
   , public org::bosch::cm::navigation::NavigationSDSService::SelectHapticHandOverListCallbackIF
{
   public:
      NaviHapticHandOverInterface(::boost::shared_ptr<org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy> naviProxy,
                                  clSDS_Property_CommonActionRequest* _pPropertyCommonActionRequest,
                                  clSDS_MultipleDestinationsList* pMultipleDestinationList,
                                  clSDS_POIList* pPOIList,
                                  NaviPOICategoryList* pNaviPOICategoryList,
                                  NaviHapticHandOverList* pNaviHapticHandOverList,
                                  clSDS_NaviListItems* pNaviListItems);
      virtual ~NaviHapticHandOverInterface();

      virtual void onUnavailable(
         const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange);

      virtual void onAvailable(
         const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange);

      void onHandOverSessionStatusUpdate(const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy >& proxy, const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::HandOverSessionStatusUpdate >& update);
      void onHandOverSessionStatusError(const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy >& proxy, const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::HandOverSessionStatusError >& error);
      void onGetHapticHandOverDataError(const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy >& proxy, const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::GetHapticHandOverDataError >& error);
      void onGetHapticHandOverDataResponse(const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy >& proxy, const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::GetHapticHandOverDataResponse >& response);
      void onSelectHapticHandOverListError(const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy >& proxy, const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::SelectHapticHandOverListError >& error);
      void onSelectHapticHandOverListResponse(const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy >& proxy, const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::SelectHapticHandOverListResponse >& response);

      void mapHmiToSdsEntryPoint();
      bool getHandOverDataFromDB(org::bosch::cm::navigation::NavigationSDSService::SDSHandOverScreenId screenID, const std::string& handOverType, std::string& sdsScreenID);
      bool isHandOverSession() const;
      bool isPOIListViaHaptic() const;
      void resetPOIListViaHaptic();
      void sendNaviHandOverPTTRequest();
      void handleNaviHandOverPTTRequest(const std::string& handOverSdsScreen, std::vector<org::bosch::cm::navigation::NavigationSDSService::SelectedDataItem> selectedDataList, const std::string& handOverType, std::vector<org::bosch::cm::navigation::NavigationSDSService::SDSHandOverOptions> handOverOption);
      void setHandOverHMIListContents(sds2hmi_fi_tcl_e8_SDS_EntryPoint::tenType sdsScreen);
      void setHandOverDataListItems(sds2hmi_fi_tcl_e8_SDS_EntryPoint::tenType sdsScreen);

   private:

      boost::shared_ptr<org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy > _naviSDSProxy;
      clSDS_Property_CommonActionRequest* _pPropertyCommonActionRequest;
      clSDS_MultipleDestinationsList* _pMultipleDestinationList;
      clSDS_POIList* _pPOIList;
      clSDS_NaviListItems* _pNaviListItems;
      NaviPOICategoryList* _pNaviPOICategoryList;
      NaviHapticHandOverList* _pNaviHapticHandOverList;

      std::map<std::string, sds2hmi_fi_tcl_e8_SDS_EntryPoint::tenType> _handOverScreenInfoMap;

      bool _isNaviHandOverScreenActive;
      bool findSdsEntryPointFromNaviInput(const std::string& ScreenID, sds2hmi_fi_tcl_e8_SDS_EntryPoint::tenType& sdsScreen);
      void resetHandOverData();
      org::bosch::cm::navigation::NavigationService::DirectionDescription getPOIDirection(org::bosch::cm::navigation::NavigationSDSService::DirectionDescription direction);
      std::string calculateHandOverType(const int handOverDataListSize);
      sds2hmi_fi_tcl_e8_Data_Exchange_Type::tenType getHandOverType(const std::string& handOverType);
      std::vector<std::string> removeDuplicateDataListItems(std::vector<std::string> ambigousDataList);
      std::vector<std::string> _dataList;
      std::vector<std::string> _uniqueList;
      std::vector<sds2hmi_fi_tcl_NDSID> _dataNDSIdList;
      std::vector<org::bosch::cm::navigation::NavigationSDSService::SDSHandOverOptions> _handOverOption;
      std::string _handOverSdsScreen;
      std::string _handOverType;
      std::vector<org::bosch::cm::navigation::NavigationSDSService::SelectedDataItem> _selectedDataList;
      std::vector<org::bosch::cm::navigation::NavigationSDSService::AddressListElement> _addressWithIdInfo;
      org::bosch::cm::navigation::NavigationSDSService::LocationType _locationType;
      void findPOIScreen(sds2hmi_fi_tcl_e8_SDS_EntryPoint::tenType& sdsPOIScreen);
      void findEntryPointforEURformScreen(std::vector<org::bosch::cm::navigation::NavigationSDSService::SelectedDataItem> selectedDataList, org::bosch::cm::navigation::NavigationSDSService::SDSHandOverScreenId& sdsEURformScreen);
      void setDestinationIdList(org::bosch::cm::navigation::NavigationSDSService::GlobalNamedObjectId nameObjectId);
      bool _isPOISearch;
      bool _POIListViaHaptic;
};


#endif
