/**************************************************************************//**
 * \file       NaviAddressFormatter.cpp
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/

#include "application/NaviAddressFormatter.h"
#include "SdsAdapter_Trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SDSADP_DETAILS
#include "trcGenProj/Header/NaviAddressFormatter.cpp.trc.h"
#endif


/***********************************************************************//**
 *
 ***************************************************************************/
NaviAddressFormatter::NaviAddressFormatter(
   boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy > naviSDSProxy)
   : _naviSDSProxy(naviSDSProxy)
{
}


/***********************************************************************//**
 *
 ***************************************************************************/

NaviAddressFormatter::~NaviAddressFormatter()
{
}


/***********************************************************************//**
 *
 ***************************************************************************/

void NaviAddressFormatter::onAvailable(
   const boost::shared_ptr<asf::core::Proxy>& proxy,
   const asf::core::ServiceStateChange& /*stateChange*/)
{
   if (proxy == _naviSDSProxy)
   {
      _naviSDSProxy->sendRequestAddressFormatForAvailableCountriesRequest(*this);
   }
}


/***********************************************************************//**
 *
 ***************************************************************************/
void NaviAddressFormatter::onUnavailable(
   const boost::shared_ptr<asf::core::Proxy>& proxy,
   const asf::core::ServiceStateChange& /*stateChange*/)
{
}


/***********************************************************************//**
 *
 ***************************************************************************/
void NaviAddressFormatter::onRequestAddressFormatForAvailableCountriesError(
   const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy >& /*proxy*/,
   const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::RequestAddressFormatForAvailableCountriesError >& /*error*/)
{
}


/**************************************************************************//**
 *
 ******************************************************************************/
void NaviAddressFormatter::onRequestAddressFormatForAvailableCountriesResponse(
   const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy >& /*proxy*/,
   const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::RequestAddressFormatForAvailableCountriesResponse >& response)
{
   for (size_t i = 0; i < (response->getAddressFormatInfos()).size(); ++i)
   {
      std::vector <std::string> addressFormatVector;

      std::string str = (response->getAddressFormatInfos())[i].getAddressFormat();

      while (!str.empty())
      {
         std::string subStr;
         size_t searchStrStartPos;
         size_t searchStrEndPos;
         searchStrStartPos = str.find('<');
         searchStrEndPos = str.find('>');
         subStr = str.substr(searchStrStartPos + 1, (searchStrEndPos - 2));
         ETG_TRACE_USR4(("SubString = %s", subStr));
         addressFormatVector.push_back(subStr);
         str.erase(str.begin(), (str.begin() + searchStrEndPos + 1));
      }
      _countryAddressFormat[(response->getAddressFormatInfos())[i].getIsoCountryCode().c_str()] = addressFormatVector;
   }
}


/**************************************************************************//**
 *
 ******************************************************************************/
std::map < std::string, std::vector <std::string> > NaviAddressFormatter::getAddressFormat()
{
   return _countryAddressFormat;
}
