/**************************************************************************//**
 * \file       InfoShowMenuHandler.h
 *
 * Handles audio channel requests from the prompt player.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef InfoShowMenuHandler_h
#define InfoShowMenuHandler_h


#include "sxm_main_fi_types.h"
#include "external/sds2hmi_fi.h"


class GuiService;


class InfoShowMenuHandler
{
   public:
      virtual ~InfoShowMenuHandler();
      InfoShowMenuHandler(GuiService* pGuiService);
      bool getSxmInfoScreenStatus(sds2hmi_fi_tcl_e8_Info_Menu::tenType enType)const;

   private:
      bool getSxmSportsScreenStatus(sds2hmi_fi_tcl_e8_Info_Menu::tenType enType)const;
      bool getSxmMovieTheatersStatus(sds2hmi_fi_tcl_e8_Info_Menu::tenType enType)const;
      bool getSxmTabularWeatherStatus(sds2hmi_fi_tcl_e8_Info_Menu::tenType enType)const;
      bool getSxmStockStatus(sds2hmi_fi_tcl_e8_Info_Menu::tenType enType)const;

      GuiService* _pGuiService;
};


#endif
