/**************************************************************************//**
 * \file       InfoShowMenuHandler.cpp
 *
 * InfoShowMenuHandler class implementation
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/

#include "application/InfoShowMenuHandler.h"
#include "application/GuiService.h"


/***********************************************************************//**

 ****************************************************************************/
InfoShowMenuHandler ::~InfoShowMenuHandler()
{
}


/***********************************************************************//**

 ****************************************************************************/
InfoShowMenuHandler::InfoShowMenuHandler(GuiService* pGuiService)
   : _pGuiService(pGuiService)

{
}


/***********************************************************************//**

 ****************************************************************************/
bool InfoShowMenuHandler::getSxmInfoScreenStatus(sds2hmi_fi_tcl_e8_Info_Menu::tenType enType)const
{
   if (getSxmSportsScreenStatus(enType))
   {
      return true;
   }

   if (getSxmMovieTheatersStatus(enType))
   {
      return true;
   }

   if (getSxmTabularWeatherStatus(enType))
   {
      return true;
   }
   if (getSxmStockStatus(enType))
   {
      return true;
   }

   return false;
}


/***********************************************************************//**

 ****************************************************************************/
bool InfoShowMenuHandler::getSxmSportsScreenStatus(sds2hmi_fi_tcl_e8_Info_Menu::tenType enType)const
{
   if (_pGuiService)
   {
      switch (enType)
      {
         case sds2hmi_fi_tcl_e8_Info_Menu::FI_EN_INFO_SPORTS_FOOTBALL:

            _pGuiService->sendEventSignal(sds_gui_fi::SdsGuiService::Event__SPEECH_DIALOG_SHOW_SPORTS_FOOTBALL);
            return true;

         case sds2hmi_fi_tcl_e8_Info_Menu::FI_EN_INFO_SPORTS_BASEBALL:
            _pGuiService->sendEventSignal(sds_gui_fi::SdsGuiService::Event__SPEECH_DIALOG_SHOW_SPORTS_BASEBALL);
            return TRUE;

         case sds2hmi_fi_tcl_e8_Info_Menu::FI_EN_INFO_SPORTS_BASKETBALL:
            _pGuiService->sendEventSignal(sds_gui_fi::SdsGuiService::Event__SPEECH_DIALOG_SHOW_SPORTS_BASKETBALL);
            return true;

         case sds2hmi_fi_tcl_e8_Info_Menu::FI_EN_INFO_SPORTS_HOCKEY:
            _pGuiService->sendEventSignal(sds_gui_fi::SdsGuiService::Event__SPEECH_DIALOG_SHOW_SPORTS_ICEHOCKEY);
            return true;

         case sds2hmi_fi_tcl_e8_Info_Menu::FI_EN_INFO_SPORTS_GOLF:
            _pGuiService->sendEventSignal(sds_gui_fi::SdsGuiService::Event__SPEECH_DIALOG_SHOW_SPORTS_GOLF);
            return true;

         case sds2hmi_fi_tcl_e8_Info_Menu::FI_EN_INFO_SPORTS_AUTORACING:
            _pGuiService->sendEventSignal(sds_gui_fi::SdsGuiService::Event__SPEECH_DIALOG_SHOW_SPORTS_MOTORSPORTS);
            return true;

         case sds2hmi_fi_tcl_e8_Info_Menu::FI_EN_INFO_SPORTS_SOCCER:
            _pGuiService->sendEventSignal(sds_gui_fi::SdsGuiService::Event__SPEECH_DIALOG_SHOW_SPORTS_SOCCER);
            return true;

         case sds2hmi_fi_tcl_e8_Info_Menu::FI_EN_INFO_SPORTS_FAVOURITES:
            _pGuiService->sendEventSignal(sds_gui_fi::SdsGuiService::Event__SPEECH_DIALOG_SHOW_SPORTS_FAVOURITES);
            return true;

         default:
            return false;
      }
   }
   return false;
}


/***********************************************************************//**

 ****************************************************************************/
bool InfoShowMenuHandler::getSxmMovieTheatersStatus(sds2hmi_fi_tcl_e8_Info_Menu::tenType enType)const
{
   if (_pGuiService)
   {
      switch (enType)
      {
         case sds2hmi_fi_tcl_e8_Info_Menu::FI_EN_INFO_MOVIES_FAV_THEATERS:
            _pGuiService->sendEventSignal(sds_gui_fi::SdsGuiService::Event__SPEECH_DIALOG_SHOW_INFO_MOVIE_FAV_THEATERS);
            return true;

         case sds2hmi_fi_tcl_e8_Info_Menu::FI_EN_INFO_MOVIES_LIST_THEATERS:
            _pGuiService->sendEventSignal(sds_gui_fi::SdsGuiService::Event__SPEECH_DIALOG_SHOW_INFO_MOVIE_LIST_THEATERS);
            return true;

         case sds2hmi_fi_tcl_e8_Info_Menu::FI_EN_INFO_MOVIES_LIST_MOVIES:
            _pGuiService->sendEventSignal(sds_gui_fi::SdsGuiService::Event__SPEECH_DIALOG_SHOW_INFO_MOVIE_LIST_MOVIE);
            return true;

         default:
            return false;
      }
   }

   return false;
}


/***********************************************************************//**

 ****************************************************************************/
bool InfoShowMenuHandler::getSxmTabularWeatherStatus(sds2hmi_fi_tcl_e8_Info_Menu::tenType enType)const
{
   if (_pGuiService)
   {
      switch (enType)
      {
         case sds2hmi_fi_tcl_e8_Info_Menu::FI_EN_INFO_CURRENT_WEATHER:
            _pGuiService->sendEventSignal(sds_gui_fi::SdsGuiService::Event__SPEECH_DIALOG_SHOW_INFO_CURRENT_WEATHER_REPORT);
            return true;

         case sds2hmi_fi_tcl_e8_Info_Menu::FI_EN_INFO_WEATHER_MAP:
            _pGuiService->sendEventSignal(sds_gui_fi::SdsGuiService::Event__SPEECH_DIALOG_SHOW_INFO_WEATHER_REPORT_MAP);
            return true;

         case sds2hmi_fi_tcl_e8_Info_Menu::FI_EN_INFO_5DAY_FORECAST:
            _pGuiService->sendEventSignal(sds_gui_fi::SdsGuiService::Event__SPEECH_DIALOG_SHOW_INFO_WEATHER_5_DAY_FORECAST);
            return true;

         case sds2hmi_fi_tcl_e8_Info_Menu::FI_EN_INFO_6HOUR_FORECAST:
            _pGuiService->sendEventSignal(sds_gui_fi::SdsGuiService::Event__SPEECH_DIALOG_SHOW_INFO_WEATHER_6_HOUR_FORECAST);
            return true;

         default:
            return false;
      }
   }

   return false;
}


/***********************************************************************//**

 ****************************************************************************/
bool InfoShowMenuHandler::getSxmStockStatus(sds2hmi_fi_tcl_e8_Info_Menu::tenType enType)const
{
   if (_pGuiService)
   {
      switch (enType)
      {
         case sds2hmi_fi_tcl_e8_Info_Menu::FI_EN_INFO_STOCKS_FAVOURITES:
            _pGuiService->sendEventSignal(sds_gui_fi::SdsGuiService::Event__SPEECH_DIALOG_SHOW_INFO_STOCK);
            return true;

         default:
            return false;
      }
   }
   return false;
}
