/**************************************************************************//**
 * \file       DataHandoverHandler.h
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/

#ifndef DataHandoverHandler_h
#define DataHandoverHandler_h

#include "application/DataHandoverServiceObserver.h"

class clSDS_SdsControl;
class SdsDataHandoverService;

class DataHandoverHandler : public DataHandoverServiceObserver
{
   public:
      DataHandoverHandler(clSDS_SdsControl* pSdsControl, SdsDataHandoverService* pSdsDataHandoverService);
      virtual ~DataHandoverHandler();
      bool pttPressedOnDataHandoverScreen();
      void handleDataHandoverPTTrequest();
      void handleDialNumberDataHandover(std::string dialedDigits);
      void phoneDataHandoverScreenChanged(bool screenStatus);

   private:
      clSDS_SdsControl* _pSdsControl;
      SdsDataHandoverService* _sdsDataHandoverService;
      bool _isPhoneHandoverScreenActive;
};


#endif
