/**************************************************************************//**
 * \file       DataHandoverHandler.cpp
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/

#include "application/DataHandoverHandler.h"
#include "application/clSDS_SdsControl.h"
#include "application/SdsDataHandoverService.h"

#include "SdsAdapter_Trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SDSADP_DETAILS
#include "trcGenProj/Header/DataHandoverHandler.cpp.trc.h"
#endif

/**************************************************************************//**
* Constructor
******************************************************************************/
DataHandoverHandler::DataHandoverHandler(clSDS_SdsControl* pSdsControl, SdsDataHandoverService* pSdsDataHandoverService)
   : _pSdsControl(pSdsControl),
     _sdsDataHandoverService(pSdsDataHandoverService),
     _isPhoneHandoverScreenActive(false)
{
}


/**************************************************************************//**
* Destructor
******************************************************************************/
DataHandoverHandler::~DataHandoverHandler()
{
   _pSdsControl = NULL;
   _sdsDataHandoverService = NULL;
}


/**************************************************************************//**
*
******************************************************************************/
void DataHandoverHandler::phoneDataHandoverScreenChanged(bool screenStatus)
{
   ETG_TRACE_USR4(("DataHandoverHandler::phoneDataHandoverScreenChanged = %d", screenStatus));
   _isPhoneHandoverScreenActive = screenStatus;
}


/**************************************************************************//**
*
******************************************************************************/
void DataHandoverHandler::handleDataHandoverPTTrequest()
{
   if (_sdsDataHandoverService != NULL && _isPhoneHandoverScreenActive)
   {
      _sdsDataHandoverService->sendDialDigitsHandoverRequest(_isPhoneHandoverScreenActive);
   }
}


/**************************************************************************//**
*
******************************************************************************/
bool DataHandoverHandler::pttPressedOnDataHandoverScreen()
{
   //Todo : Add Navi data handover screen status and validate if Data Handover to be started
   return _isPhoneHandoverScreenActive;
}


/**************************************************************************//**
*
******************************************************************************/
void DataHandoverHandler::handleDialNumberDataHandover(std::string dialedDigits)
{
   if (!dialedDigits.empty())
   {
      _pSdsControl->sendDataHandoverPTTRequest(sds2hmi_fi_tcl_e8_SDS_EntryPoint::FI_EN_SDS_ENTRY_DIAL_NUMBER,
            sds2hmi_fi_tcl_e8_Data_Exchange_Type::FI_EN_DATA_SINGLE,
            sds2hmi_fi_tcl_e8_WordType::FI_EN_PHONENUMBER, dialedDigits);
   }
   else
   {
      _pSdsControl->sendDataHandoverPTTRequest(sds2hmi_fi_tcl_e8_SDS_EntryPoint::FI_EN_SDS_ENTRY_DIAL_NUMBER,
            sds2hmi_fi_tcl_e8_Data_Exchange_Type::FI_EN_DATA_NONE,
            sds2hmi_fi_tcl_e8_WordType::FI_EN_PHONENUMBER, dialedDigits);
   }
}
