/**************************************************************************//**
 * \file       CommonSettingsObserver.h
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef CommonSettingsObserver_h
#define CommonSettingsObserver_h

class CommonSettingsObserver
{
   public:
      CommonSettingsObserver();
      virtual ~CommonSettingsObserver();

      virtual void voicePreferenceChanged();
      virtual void promptModeChanged(bool promptMode);
      virtual void speechRateChanged(unsigned int speechRate);
      virtual void updateNBestMatchAudio(bool audioNBest);
      virtual void updateNBestMatchPhoneBook(bool phoneNBest);
      virtual void updateBeepOnlyMode(bool beepOnlyModeStatus);
      virtual void updateVoiceBargeIn(bool voiceBargeInStatus);
};


#endif
