/**************************************************************************//**
 * \file       AudioSourceHandler.h
 *
 * AcrHandler class implementation
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef AudioSourceHandler_h
#define AudioSourceHandler_h


#include "application/clSDS_SDSStatusObserver.h"
#include "application/SdsAudioSourceObserver.h"

class clSDS_SDSStatus;
class SdsAudioSource;
class clSDS_SessionControl;

class AudioSourceHandler : public SdsAudioSourceObserver, public clSDS_SDSStatusObserver
{
   public:
      AudioSourceHandler(clSDS_SDSStatus* pSDSStatus, SdsAudioSource& audioSource, clSDS_SessionControl* pSessionControl);
      ~AudioSourceHandler();

      tVoid vSDSStatusChanged();
      void onOutgoingCall();
      void onAudioSourceStateChanged(arl_tenActivity state);
      void setHighPriorityAppStatus(bool isHighPrioApp);

   private:
      void tryResumeSessionIfPaused();
      void resetFlags();

      clSDS_SDSStatus* _pSDSStatus;
      SdsAudioSource& _audioSource;
      clSDS_SessionControl* _pSessionControl;
      arl_tenActivity _audioState;
      bool _ignorePause;
      bool _pauseSessionRequested;
      bool _highPrioAppStatus;
      bool _waitingForExitPause;
};


#endif
