/**************************************************************************//**
 * \file       clSDS_Property_NaviPOIIconList.cpp
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2018 Robert Bosch GmbH
 *             (C) 2018 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#include "Sds2HmiServer/functions/clSDS_Property_NaviPOIIconList.h"
#include "application/StringUtils.h"
#include <sstream>

#include "SdsAdapter_Trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SDSADP_DETAILS
#include "trcGenProj/Header/clSDS_Property_NaviPOIIconList.cpp.trc.h"
#endif


clSDS_Property_NaviPOIIconList::clSDS_Property_NaviPOIIconList(ahl_tclBaseOneThreadService* pService)
   : clServerProperty(SDS2HMI_SDSFI_C_U16_NAVIPOIICONLIST, pService)
{
}


clSDS_Property_NaviPOIIconList::~clSDS_Property_NaviPOIIconList()
{
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clSDS_Property_NaviPOIIconList::vSet(amt_tclServiceData* pInMsg)
{
   sds2hmi_sdsfi_tclMsgNaviPOIIconListSet oMessage;
   vGetDataFromAmt(pInMsg, oMessage);
   vStatus(oMessage);
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clSDS_Property_NaviPOIIconList::vGet(amt_tclServiceData* /*pInMsg*/)
{
   sds2hmi_sdsfi_tclMsgNaviPOIIconListStatus oMessage;
   vStatus(oMessage);
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clSDS_Property_NaviPOIIconList::vUpreg(amt_tclServiceData* /*pInMsg*/)
{
   sds2hmi_sdsfi_tclMsgNaviPOIIconListStatus oMessage;
   vStatus(oMessage);
}


static void tracePoiIconList(const sds2hmi_sdsfi_tclMsgNaviPOIIconListStatus& status)
{
   if (etg_bIsTraceActive(TR_CLASS_SDSADP_DETAILS, ETG_LEVEL_USER_4))
   {
      std::string lang = StringUtils::toISOString(status.LanguageID.ISO639_3_SDSLanguageCode.enType);
      lang += "_";
      lang += StringUtils::toISOString(status.LanguageID.ISO3166_CountryCode.enType);
      ETG_TRACE_USR4(("POIIconList: Language: %s", lang.c_str()));

      for (size_t i = 0; i < status.DescriptionList.size(); ++i)
      {
         const sds2hmi_fi_tcl_HMIElementDescription& elem = status.DescriptionList[i];
         std::stringstream elemLine;
         elemLine << "id=" << elem.DescriptorId << ", ";
         elemLine << "tag=" << elem.DescriptorTag.enType << ", ";
         elemLine << "value=" << getString(elem.DescriptorValue) << ", ";
         elemLine << "numOfDestIds" << elem.DestinationIdList.size() << ", ";
         elemLine << "numOfPhonemes" << elem.PhonemeList.size();
         ETG_TRACE_USR4(("POIIconList: HMIElementDescription[%d]={%s}", i, elemLine.str().c_str()));
      }
   }
}


void clSDS_Property_NaviPOIIconList::sendNaviPOIIconListToSDS(sds2hmi_sdsfi_tclMsgNaviPOIIconListStatus poiIconListInfo)
{
   tracePoiIconList(poiIconListInfo);
   vStatus(poiIconListInfo);
}
