/**************************************************************************//**
 * \file       clSDS_Property_NavDataDataSetInfo.h
 *
 * NavDataActiveDataSet property implementation
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_Property_NavDataDataSetInfo_h
#define clSDS_Property_NavDataDataSetInfo_h


#include "Sds2HmiServer/framework/clServerProperty.h"
#include "org/bosch/cm/navigation/NavigationSDSServiceProxy.h"
#include "external/sds2hmi_fi.h"

#define FI_S_IMPORT_INTERFACE_FI_TYPES
#include "fi_if.h"


class NavigationAvailabilityObserver;


class clSDS_Property_NavDataDataSetInfo
   : public clServerProperty
   , public asf::core::ServiceAvailableIF
   , public org::bosch::cm::navigation::NavigationSDSService::NavDatasetInfoCallbackIF
{
   public:
      clSDS_Property_NavDataDataSetInfo(
         ahl_tclBaseOneThreadService* pService,
         ::boost::shared_ptr<org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy> naviSDSProxy);

      virtual ~clSDS_Property_NavDataDataSetInfo();

      void onAvailable(
         const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange);
      void onUnavailable(
         const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange);

      void onNavDatasetInfoError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavDatasetInfoError >& error);
      void onNavDatasetInfoUpdate(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavDatasetInfoUpdate >& update);
      void addNavDataObserver(NavigationAvailabilityObserver* pObserver);

   protected:
      virtual tVoid vGet(amt_tclServiceData* pInMsg);
      virtual tVoid vSet(amt_tclServiceData* pInMsg);
      virtual tVoid vUpreg(amt_tclServiceData* pInMsg);

   private:
      boost::shared_ptr<org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy> _naviSDSProxy;
      void sendResponse();
      void sendNavDataSetInfoStatus(const org::bosch::cm::navigation::NavigationSDSService::NavDataSetInfo& dataSetInfo);
      void mapNaviUnittoSDSUnit();
      void notifyNavDataObservers();
      void setAvailability(uint32 dataSetId);
      std::map<org::bosch::cm::navigation::NavigationSDSService::SharedDataAccess, sds2hmi_fi_tcl_e8_SharedDataAccess::tenType> _sharedDataAccessMap;
      std::map<org::bosch::cm::navigation::NavigationSDSService::JournalingMode, sds2hmi_fi_tcl_e8_JournalingMode::tenType> _journalingModeMap;
      std::map<org::bosch::cm::navigation::NavigationSDSService::LockType, sds2hmi_fi_tcl_e8_LockType::tenType> _lockTypeMap;
      std::vector<NavigationAvailabilityObserver*> _NavDataObservers;
      uint32 _dataSetId;
};


#endif
