/**************************************************************************//**
 * \file       clSDS_Property_MediaStatus.h
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_Property_MediaStatus_h
#define clSDS_Property_MediaStatus_h


#include "Sds2HmiServer/framework/clServerProperty.h"
#include "external/sds2hmi_fi.h"
#include "mplay_MediaPlayer_FIProxy.h"
#include "smartphoneint_main_fiProxy.h"


class clSDS_Property_MediaStatus
   : public clServerProperty
   , public asf::core::ServiceAvailableIF
   , public mplay_MediaPlayer_FI::MediaPlayerDeviceConnectionsCallbackIF
   , public smartphoneint_main_fi::SessionStatusInfoCallbackIF
{
   public:
      virtual ~clSDS_Property_MediaStatus();
      clSDS_Property_MediaStatus(
         ahl_tclBaseOneThreadService* pService,
         ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy > pSds2MediaProxy,
         ::boost::shared_ptr< ::smartphoneint_main_fi::Smartphoneint_main_fiProxy > smartphoneProxy);

      void onAvailable(
         const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange);

      void onUnavailable(
         const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange);

      virtual void onMediaPlayerDeviceConnectionsStatus(
         const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
         const boost::shared_ptr< ::mplay_MediaPlayer_FI::MediaPlayerDeviceConnectionsStatus >& status);
      virtual void onMediaPlayerDeviceConnectionsError(
         const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& proxy,
         const boost::shared_ptr< ::mplay_MediaPlayer_FI::MediaPlayerDeviceConnectionsError >& error);

      virtual void onSessionStatusInfoError(
         const ::boost::shared_ptr< ::smartphoneint_main_fi::Smartphoneint_main_fiProxy >& proxy,
         const ::boost::shared_ptr< ::smartphoneint_main_fi::SessionStatusInfoError >& error);
      virtual void onSessionStatusInfoStatus(
         const ::boost::shared_ptr< ::smartphoneint_main_fi::Smartphoneint_main_fiProxy >& proxy,
         const ::boost::shared_ptr< ::smartphoneint_main_fi::SessionStatusInfoStatus >& status);

   protected:
      virtual tVoid vGet(amt_tclServiceData* pInMsg);
      virtual tVoid vSet(amt_tclServiceData* pInMsg);
      virtual tVoid vUpreg(amt_tclServiceData* pInMsg);

   private:

      tVoid vSendStatus();
      sds2hmi_fi_tcl_e8_MPL_SourceType::tenType eGetMediaPlayerSource(size_t idx) const;
      sds2hmi_fi_tcl_e8_DeviceStatus::tenType eGetDeviceStatus(size_t idx) const;
      tBool bUsbSourceAvailable(size_t idx) const;
      tBool isDeviceConnectedInEvenPortNumber(std::string& sysPath) const;
      tBool bIpodSourceAvailable(size_t) const;
      tBool bMediaSourceAvailable(size_t idx) const;
      tBool bBTSourceAvailable(size_t idx) const;
      tBool bCdAvailable(size_t idx) const;
      tBool bAuxSourceAvailable() const;
      tBool bDvdAvailable(size_t idx) const;
      tBool bMusicBoxAvailable(size_t idx) const;
      tVoid vUpdateDeviceList(std::vector<sds2hmi_fi_tcl_DeviceStatus>& oDeviceList) ;
      tVoid vUpdateMediaDeviceStatus(sds2hmi_fi_tcl_DeviceStatus& oDeviceStatus, size_t idx) const;
      tVoid vUpdateDeviceListWithMedia(std::vector<sds2hmi_fi_tcl_DeviceStatus>& oDeviceList) ;
      tVoid vUpdateDeviceListWithBTAudio(std::vector<sds2hmi_fi_tcl_DeviceStatus>& oDeviceList) const;
      tVoid vUpdateDeviceListWithAux(std::vector<sds2hmi_fi_tcl_DeviceStatus>& oDeviceList) const;
      tVoid vUpdateDeviceListWithCD(std::vector<sds2hmi_fi_tcl_DeviceStatus>& oDeviceList) const;
      void updateDeviceListWithCarPlayAudio(std::vector<sds2hmi_fi_tcl_DeviceStatus>& oDeviceList) const;
      void updateDeviceListWithAndroidAutoAudio(std::vector<sds2hmi_fi_tcl_DeviceStatus>& oDeviceList) const;
      tVoid vTraceMediaStatus(const sds2hmi_sdsfi_tclMsgMediaStatusStatus& oMessage) const;
      tVoid vUpdateDeviceListWithDVD(std::vector<sds2hmi_fi_tcl_DeviceStatus>& oDeviceList) const;
      tVoid vUpdateDeviceListWithMusicBox(std::vector<sds2hmi_fi_tcl_DeviceStatus>& oDeviceList) const;

      void updateCarPlayAndroidAutoStatus(bool carPlay, bool androidAuto);
      void updateCDConnected(bool cdConnected) const;
      void updateDVDConnected(bool dvdConnected) const;
      void updateCDTrackAvailable(bool cdtrackAvailable) const;

      tBool bIsDeviceSupportCDtracks(size_t idx) const;
      tBool bIsCDDeviceSupportSourceChangeOnly(size_t idx) const;
      tBool diff(const MPlay_fi_types::T_MPlayDeviceInfo& currentDeviceInfoList, const MPlay_fi_types::T_MPlayDeviceInfo& newDeviceInfoList);

      boost::shared_ptr<mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy>_sds2MediaProxy;
      boost::shared_ptr<smartphoneint_main_fi::Smartphoneint_main_fiProxy > _smartphoneProxy;

      MPlay_fi_types::T_MPlayDeviceInfo _oDeviceList;
      bool _carPlayAvailable;
      bool _androidAutoAvailable;
};


#endif
