/**************************************************************************//**
 * \file       clSDS_Property_ConnectedDeviceStatus.cpp
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#include "Sds2HmiServer/functions/clSDS_Property_ConnectedDeviceStatus.h"
#include "external/sds2hmi_fi.h"
#include "application/SdsPhoneService.h"

using namespace sds_gui_fi::SdsPhoneService;

/**************************************************************************//**
* Destructor
******************************************************************************/
clSDS_Property_ConnectedDeviceStatus::~clSDS_Property_ConnectedDeviceStatus()
{
   _pSdsPhoneService = NULL;
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clSDS_Property_ConnectedDeviceStatus::clSDS_Property_ConnectedDeviceStatus(
   ahl_tclBaseOneThreadService* pService,
   SdsPhoneService* pSdsPhoneService)
   : clServerProperty(SDS2HMI_SDSFI_C_U16_CONNECTEDDEVICESTATUS, pService)
   , _pSdsPhoneService(pSdsPhoneService)
   , _mediaState(0)
   , _phonebookPhonetizationStatus(sds2hmi_fi_tcl_e8_ConnectedDeviceUpdateStatus::FI_EN_DEVICEUNAVAILABLE)
{
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clSDS_Property_ConnectedDeviceStatus::vSet(amt_tclServiceData* pInMsg)
{
   sds2hmi_sdsfi_tclMsgConnectedDeviceStatusSet message;
   vGetDataFromAmt(pInMsg, message);
   this->_connectedDeviceStatus = message.ConnectedDeviceStatus;
   this->_mediaState = message.MediaState;
   this->_e8Slot = message.e8Slot;
   extractConnectedDevicePhonetizationstatus(this->_connectedDeviceStatus);
   vSendStatus();
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clSDS_Property_ConnectedDeviceStatus::vGet(amt_tclServiceData*  /*pInMsg*/)
{
   vSendStatus();
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clSDS_Property_ConnectedDeviceStatus::vUpreg(amt_tclServiceData*  /*pInMsg*/)
{
   vSendStatus();
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clSDS_Property_ConnectedDeviceStatus::vSendStatus()
{
   sds2hmi_sdsfi_tclMsgConnectedDeviceStatusStatus message;
   message.ConnectedDeviceStatus = this->_connectedDeviceStatus;
   message.MediaState = this->_mediaState;
   message.e8Slot = this->_e8Slot;
   vStatus(message);
}


/**************************************************************************//**
*
******************************************************************************/
void clSDS_Property_ConnectedDeviceStatus::extractConnectedDevicePhonetizationstatus(
   const std::vector<sds2hmi_fi_tcl_ConnectedDeviceStatus>& connectedDeviceStatus)
{
   std::vector<sds2hmi_fi_tcl_ConnectedDeviceStatus> ::const_iterator deviceStatusIter = connectedDeviceStatus.begin();

   while (deviceStatusIter != connectedDeviceStatus.end())
   {
      if (deviceStatusIter->tenDomain.enType == sds2hmi_fi_tcl_e8_Domain::FI_EN_PHONE)
      {
         sendPhonebookPhonetizationStatus(deviceStatusIter->UpdateStatus.enType);
      }
      ++deviceStatusIter;
   }
}


/**************************************************************************//**
*
******************************************************************************/
void clSDS_Property_ConnectedDeviceStatus::sendPhonebookPhonetizationStatus(sds2hmi_fi_tcl_e8_ConnectedDeviceUpdateStatus::tenType entype)
{
   if (_pSdsPhoneService != NULL && _phonebookPhonetizationStatus != entype)
   {
      switch (entype)
      {
         case sds2hmi_fi_tcl_e8_ConnectedDeviceUpdateStatus::FI_EN_DEVICEUNAVAILABLE:
            _pSdsPhoneService->sendPhoneBookPhonetizationSignal(PhoneBookPhonetization__DEVICEUNAVAILABLE);
            break;
         case sds2hmi_fi_tcl_e8_ConnectedDeviceUpdateStatus::FI_EN_DEVICEAVAILABLEUPDATERUNNING:
            _pSdsPhoneService->sendPhoneBookPhonetizationSignal(PhoneBookPhonetization__DEVICEAVAILABLEUPDATERUNNING);
            break;
         case sds2hmi_fi_tcl_e8_ConnectedDeviceUpdateStatus::FI_EN_DEVICEUNVAILABLEUPDATERUNNING:
            _pSdsPhoneService->sendPhoneBookPhonetizationSignal(PhoneBookPhonetization__DEVICEUNVAILABLEUPDATERUNNING);
            break;
         case sds2hmi_fi_tcl_e8_ConnectedDeviceUpdateStatus::FI_EN_DEVICEAVAILABLEUPTODATE:
            _pSdsPhoneService->sendPhoneBookPhonetizationSignal(PhoneBookPhonetization__DEVICEAVAILABLEUPTODATE);
            break;
         default:
            break;
      }
   }
   _phonebookPhonetizationStatus = entype;
}
