/**************************************************************************//**
 * \file       clSDS_Property_CommonSettingsRequest.h
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_Property_CommonSettingsRequest_h
#define clSDS_Property_CommonSettingsRequest_h


#include "Sds2HmiServer/framework/clServerProperty.h"
#include "external/sds2hmi_fi.h"
#include "application/CommonSettingsObserver.h"

class SettingsService;


class clSDS_Property_CommonSettingsRequest : public clServerProperty,
   public CommonSettingsObserver
{
   public:
      virtual ~clSDS_Property_CommonSettingsRequest();
      clSDS_Property_CommonSettingsRequest(ahl_tclBaseOneThreadService* pService, SettingsService* settingsService);
      void promptModeChanged(bool promptMode);
      void speechRateChanged(unsigned int speechRate);

   protected:
      virtual tVoid vGet(amt_tclServiceData* pInMsg);
      virtual tVoid vSet(amt_tclServiceData* pInMsg);
      virtual tVoid vUpreg(amt_tclServiceData* pInMsg);

   private:

      clSDS_Property_CommonSettingsRequest(const clSDS_Property_CommonSettingsRequest& pclSDSPropertyCommonSettingsRequest);                // copy constructor
      clSDS_Property_CommonSettingsRequest& operator = (const clSDS_Property_CommonSettingsRequest& pclSDSPropertyCommonSettingsRequest);   // assignment constructor

      tVoid vSendStatus(sds2hmi_fi_tcl_e8_SDSSettings::tenType);
      bool _promptMode;
      tU32  _speechRate;
      sds2hmi_fi_tclU32* _pofiU32Value ;
      sds2hmi_fi_tcl_SDS_SettingsUnion oSettingsUnion;
};


#endif
