/**************************************************************************//**
 * \file       clSDS_Property_CommonSDSConfiguration_Stat.cpp
 *
 * Common SDS Configuration property implementation
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#include "Sds2HmiServer/functions/clSDS_Property_CommonSDSConfiguration_Stat.h"
#include "application/clSDS_XMLStringCreation.h"
#include "external/sds2hmi_fi.h"
#include "SdsAdapter_Trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SDSADP_DETAILS
#include "trcGenProj/Header/clSDS_Property_CommonSDSConfiguration_Stat.cpp.trc.h"
#endif


/**************************************************************************//**
*
******************************************************************************/
clSDS_Property_CommonSDSConfiguration_Stat::~clSDS_Property_CommonSDSConfiguration_Stat()
{
}


/**************************************************************************//**
*
******************************************************************************/
clSDS_Property_CommonSDSConfiguration_Stat::clSDS_Property_CommonSDSConfiguration_Stat(
   ahl_tclBaseOneThreadService* pService)

   : clServerProperty(SDS2HMI_SDSFI_C_U16_COMMONSDSCONFIGURATION_STAT, pService)
{
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clSDS_Property_CommonSDSConfiguration_Stat::vGet(amt_tclServiceData* /*pInMsg*/)
{
   vSendStatus();
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clSDS_Property_CommonSDSConfiguration_Stat::vSet(amt_tclServiceData* /*pInMsg*/)
{
   vSendStatus();
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clSDS_Property_CommonSDSConfiguration_Stat::vUpreg(amt_tclServiceData* /*pInMsg*/)
{
   vSendStatus();
}


/**************************************************************************//**
*
******************************************************************************/
static void traceXmlString(const std::string& str)
{
   const size_t chunkSize = 100;
   for (size_t pos = 0; pos < str.size(); pos += chunkSize)
   {
      std::string chunk = str.substr(pos, chunkSize);
      ETG_TRACE_USR1(("SDS Config '%s'", chunk.c_str()));
   }
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clSDS_Property_CommonSDSConfiguration_Stat::vSendStatus()
{
   std::string staticString = clSDS_XMLStringCreation::getStaticXmlString();

   ETG_TRACE_USR1(("SDS Config === Static ==="));
   traceXmlString(staticString);

   sds2hmi_sdsfi_tclMsgCommonSDSConfiguration_StatStatus oMessage;
   oMessage.Value.bSet(staticString.c_str(), sds2hmi_fi_tclString::FI_EN_UTF8);
   vStatus(oMessage);
}
