/**************************************************************************//**
 * \file       clSDS_Property_CommonActionRequest.h
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_Property_CommonActionRequest_h
#define clSDS_Property_CommonActionRequest_h


#include "Sds2HmiServer/framework/clServerProperty.h"
#include "application/clSDS_SdsControl.h"

class clSDS_LanguageMediator;


class clSDS_Property_CommonActionRequest : public clServerProperty, public clSDS_SdsControl
{
   public:
      virtual ~clSDS_Property_CommonActionRequest();
      clSDS_Property_CommonActionRequest(ahl_tclBaseOneThreadService* pService, clSDS_LanguageMediator* languageMediator);
      tVoid vSendPttEvent(tU32 u32Context);
      tVoid vSendPTTLongPressEvent();
      tVoid vSendBackEvent();
      tVoid vAbortDialog();
      tVoid vDeleteUserWord(tU32 tU32UWID, sds2hmi_fi_tcl_e8_Domain::tenType enDomain);
      tVoid vDeleteAllUserWords(tU32 tU32UWProfile, sds2hmi_fi_tcl_e8_Domain::tenType enDomain);
      tVoid vSetUWProfile(tU32 u32NewSDSUser, sds2hmi_fi_tcl_e8_Domain::tenType enDomain);
      tVoid vSetSpeaker(tU16 u16SpeakerId);
      tVoid vRequestAllSpeakers();
      tVoid vClearPrivateData();
      tVoid sendEnterManualMode();
      void sendFocusMoved(unsigned int value);
      void sendNextPageRequest();
      void sendPreviousPageRequest();
      void sendListSelectRequest(unsigned int value);
      void sendSelectRequest(unsigned int value);
      void sendCancelDialog();
      void recordUserWord(unsigned long userWordListID, sds2hmi_fi_tcl_e8_Domain::tenType enDomain);
      void replaceUserWord(unsigned long userWordListID, sds2hmi_fi_tcl_e8_Domain::tenType enDomain);
      void playUserWord(unsigned long userWordListID, sds2hmi_fi_tcl_e8_Domain::tenType enDomain);
      void sendEnterPauseMode();
      void sendExitPauseMode();
      void sendDataHandoverPTTRequest(sds2hmi_fi_tcl_e8_SDS_EntryPoint::tenType entryPoint,
                                      sds2hmi_fi_tcl_e8_Data_Exchange_Type::tenType dataexchangeType,
                                      sds2hmi_fi_tcl_e8_WordType::tenType wordType,
                                      std::string infoString);
      void sendNaviHandoverPTTRequest(sds2hmi_sdsfi_tclMsgCommonActionRequestStatus handOverInfo);

   protected:
      virtual tVoid vGet(amt_tclServiceData* pInMsg);
      virtual tVoid vSet(amt_tclServiceData* pInMsg);
      virtual tVoid vUpreg(amt_tclServiceData* pInMsg);

   private:
      clSDS_LanguageMediator* _pLanguageMediator;
};


#endif
