/**************************************************************************//**
 * \file       clSDS_Method_PhoneUpdatePhonebook.h
 *
  * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2017 Robert Bosch GmbH
 *             (C) 2017 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_Method_PhoneUpdatePhonebook_h
#define clSDS_Method_PhoneUpdatePhonebook_h


#include "Sds2HmiServer/framework/clServerMethod.h"
#include "MOST_PhonBk_FIProxy.h"
#include "MOST_Tel_FIProxy.h"
#include "application/AmbigNumberListObserver.h"


class clSDS_Method_PhoneUpdatePhonebook
   : public clServerMethod
   , public asf::core::ServiceAvailableIF
   , public MOST_PhonBk_FI::GetContactDetailsExtendedCallbackIF
   , public MOST_PhonBk_FI::EditContactExtendedCallbackIF
   , public MOST_PhonBk_FI::AddContactExtendedCallbackIF
   , public MOST_Tel_FI::ActivePhoneDeviceCallbackIF
   , public AmbigNumberListObserver
{
   public:
      clSDS_Method_PhoneUpdatePhonebook(ahl_tclBaseOneThreadService* pService,
                                        ::boost::shared_ptr< MOST_PhonBk_FI::MOST_PhonBk_FIProxy> phonebookProxy,
                                        ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy > pSds2TelProxy);
      virtual ~clSDS_Method_PhoneUpdatePhonebook();

   private:
      tVoid vMethodStart(amt_tclServiceData* pInMsg);

      void onAvailable(
         const ::boost::shared_ptr< asf::core::Proxy >& proxy,
         const asf::core::ServiceStateChange& stateChange);
      void onUnavailable(
         const ::boost::shared_ptr< asf::core::Proxy >& proxy,
         const asf::core::ServiceStateChange& stateChange);

      void onGetContactDetailsExtendedError(
         const ::boost::shared_ptr< MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& proxy,
         const ::boost::shared_ptr< MOST_PhonBk_FI::GetContactDetailsExtendedError >& error);
      void onGetContactDetailsExtendedResult(
         const ::boost::shared_ptr< MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& proxy,
         const ::boost::shared_ptr< MOST_PhonBk_FI::GetContactDetailsExtendedResult >& result);

      void onEditContactExtendedError(
         const ::boost::shared_ptr< MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& proxy,
         const ::boost::shared_ptr< MOST_PhonBk_FI::EditContactExtendedError >& error);
      void onEditContactExtendedResult(
         const ::boost::shared_ptr< MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& proxy,
         const ::boost::shared_ptr< MOST_PhonBk_FI::EditContactExtendedResult >& result);

      void onAddContactExtendedError(
         const ::boost::shared_ptr< MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& proxy,
         const ::boost::shared_ptr< MOST_PhonBk_FI::AddContactExtendedError >& error);
      void onAddContactExtendedResult(
         const ::boost::shared_ptr< MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& proxy,
         const ::boost::shared_ptr< MOST_PhonBk_FI::AddContactExtendedResult >& result);

      //callback for ActivePhoneDeviceStatus from Tel FI
      void onActivePhoneDeviceError(
         const ::boost::shared_ptr< MOST_Tel_FI::MOST_Tel_FIProxy >& proxy,
         const ::boost::shared_ptr< MOST_Tel_FI::ActivePhoneDeviceError >& error);
      void onActivePhoneDeviceStatus(
         const ::boost::shared_ptr< MOST_Tel_FI::MOST_Tel_FIProxy >& proxy,
         const ::boost::shared_ptr< MOST_Tel_FI::ActivePhoneDeviceStatus >& status);

      void ambigNumbersUpdated(const NumberDetails& ambigNumberDetails);

      ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy> _phonebookProxy;
      ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy>  _telephoneProxy;
      uint32 _relationship;
      uint32 _contactHandle;
      uint8 _deviceHandle;
      std::string _contactName;
      NumberDetails _ambigNumberDetails;
};


#endif
