/**************************************************************************//**
 * \file       clSDS_Method_PhoneUpdatePhonebook.cpp
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2017 Robert Bosch GmbH
 *             (C) 2017 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#include "clSDS_Method_PhoneUpdatePhonebook.h"
#include "external/sds2hmi_fi.h"
#include "application/StringUtils.h"
#include "SdsAdapter_Trace.h"
#include "application/PhoneUtils.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_SDSADP_DETAILS
#include "trcGenProj/Header/clSDS_Method_PhoneUpdatePhonebook.cpp.trc.h"
#endif


/**************************************************************************//**
 * Constructor
 ******************************************************************************/
clSDS_Method_PhoneUpdatePhonebook::clSDS_Method_PhoneUpdatePhonebook(
   ahl_tclBaseOneThreadService* pService,
   ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy> phonebookProxy,
   ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy > pSds2TelProxy)
   : clServerMethod(SDS2HMI_SDSFI_C_U16_PHONEUPDATEPHONEBOOK, pService),
     _phonebookProxy(phonebookProxy),
     _telephoneProxy(pSds2TelProxy),
     _relationship(0),
     _contactHandle(0),
     _deviceHandle(0),
     _contactName(""),
     _ambigNumberDetails()
{
}


/**************************************************************************//**
 * Destructor
 ******************************************************************************/
clSDS_Method_PhoneUpdatePhonebook::~clSDS_Method_PhoneUpdatePhonebook()
{
}


/**************************************************************************//**
 *
 ******************************************************************************/
tVoid clSDS_Method_PhoneUpdatePhonebook::vMethodStart(amt_tclServiceData* pInMsg)
{
   ETG_TRACE_USR4(("clSDS_Method_PhoneUpdatePhonebook::vMethodStart"));

   sds2hmi_sdsfi_tclMsgPhoneUpdatePhoneBookMethodStart oMessage;
   vGetDataFromAmt(pInMsg, oMessage);

   _relationship = oMessage.Relationship.enType;
   _contactHandle = oMessage.UniqueId;
   _contactName = oMessage.ContactInfo.szValue;

   if ((_telephoneProxy->hasActivePhoneDevice()))
   {
      _deviceHandle = _telephoneProxy->getActivePhoneDevice().getU8DeviceHandle();
      ETG_TRACE_USR4(("clSDS_Method_PhoneUpdatePhonebook::vMethodStart Relationship = %d", oMessage.Relationship.enType));

      if (oMessage.Action.enType == sds2hmi_fi_tcl_e8_PhBook_Update_Action::FI_EN_UPDATE_RELATIONSHIP)
      {
         _phonebookProxy->sendGetContactDetailsExtendedStart(*this, _contactHandle);
      }
      else
      {
         vSendErrorMessage(SDS2HMI_SDSFI_C_U16_ERROR_CANNOTCOMPLETEACTION);
      }
   }
   else
   {
      vSendErrorMessage(SDS2HMI_SDSFI_C_U16_ERROR_CANNOTCOMPLETEACTION);
   }
}


/**************************************************************************//**
 *
 ******************************************************************************/
void clSDS_Method_PhoneUpdatePhonebook::onAvailable(
   const ::boost::shared_ptr< asf::core::Proxy >& proxy,
   const asf::core::ServiceStateChange& /*stateChange*/)
{
   if (proxy == _telephoneProxy)
   {
      _telephoneProxy->sendActivePhoneDeviceUpReg(*this);
   }
}


/**************************************************************************//**
 *
 ******************************************************************************/
void clSDS_Method_PhoneUpdatePhonebook::onUnavailable(
   const ::boost::shared_ptr< asf::core::Proxy >& proxy,
   const asf::core::ServiceStateChange& /*stateChange*/)
{
   if (proxy == _telephoneProxy)
   {
      _telephoneProxy->sendActivePhoneDeviceRelUpRegAll();
   }
}


/**************************************************************************//**
 *
 ******************************************************************************/
void clSDS_Method_PhoneUpdatePhonebook::onGetContactDetailsExtendedError(
   const ::boost::shared_ptr< MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/,
   const ::boost::shared_ptr< MOST_PhonBk_FI::GetContactDetailsExtendedError >& /*error*/)
{
   vSendErrorMessage(SDS2HMI_SDSFI_C_U16_ERROR_CANNOTCOMPLETEACTION);
}


/**************************************************************************//**
 *
 ******************************************************************************/
void clSDS_Method_PhoneUpdatePhonebook::onGetContactDetailsExtendedResult(
   const ::boost::shared_ptr< MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/,
   const ::boost::shared_ptr< MOST_PhonBk_FI::GetContactDetailsExtendedResult >& result)
{
   most_PhonBk_fi_types_Extended::T_PhonBkContactDetailsExtended contactDetailsExtended;
   contactDetailsExtended = result->getOContactDetailsExtended();
   contactDetailsExtended.setSCategory(StringUtils::toString(_relationship));
   _phonebookProxy->sendEditContactExtendedStart(*this, _deviceHandle, _contactHandle, contactDetailsExtended);
}


/**************************************************************************//**
 *
 ******************************************************************************/
void clSDS_Method_PhoneUpdatePhonebook::onEditContactExtendedError(
   const ::boost::shared_ptr< MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/,
   const ::boost::shared_ptr< MOST_PhonBk_FI::EditContactExtendedError >& /*error*/)
{
   /*
    * In case editing a vehicle phonebook contact results in an error,
    * the contact will be added to the vehicle phonebook.
    */
   most_PhonBk_fi_types_Extended::T_PhonBkContactDetailsExtended contactDetailsExtended;
   contactDetailsExtended.setSCategory(StringUtils::toString(_relationship));
   contactDetailsExtended.setSFirstName(_contactName);
   contactDetailsExtended.setSLastName("");
   most_PhonBk_fi_types_Extended::T_PhonBkPhoneNumberItem phnNumItem;
   phnNumItem.setSNumber(_ambigNumberDetails.phoneNumber);
   phnNumItem.setE8Type(_ambigNumberDetails.numberType);
   contactDetailsExtended.setOPhoneNumber1(phnNumItem);
   _phonebookProxy->sendAddContactExtendedStart(*this, _deviceHandle, contactDetailsExtended);
}


/**************************************************************************//**
 *
 ******************************************************************************/
void clSDS_Method_PhoneUpdatePhonebook::onEditContactExtendedResult(
   const ::boost::shared_ptr< MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/,
   const ::boost::shared_ptr< MOST_PhonBk_FI::EditContactExtendedResult >& result)
{
   vSendMethodResult();
}


/**************************************************************************//**
 *
 ******************************************************************************/
void clSDS_Method_PhoneUpdatePhonebook::onAddContactExtendedError(
   const ::boost::shared_ptr< MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/,
   const ::boost::shared_ptr< MOST_PhonBk_FI::AddContactExtendedError >& /*error*/)
{
   vSendErrorMessage(SDS2HMI_SDSFI_C_U16_ERROR_CANNOTCOMPLETEACTION);
}


/**************************************************************************//**
 *
 ******************************************************************************/
void clSDS_Method_PhoneUpdatePhonebook::onAddContactExtendedResult(
   const ::boost::shared_ptr< MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& /*proxy*/,
   const ::boost::shared_ptr< MOST_PhonBk_FI::AddContactExtendedResult >& result)
{
   vSendMethodResult();
}


/**************************************************************************//**
 *
 ******************************************************************************/
void clSDS_Method_PhoneUpdatePhonebook::ambigNumbersUpdated(const NumberDetails& ambigNumberDetails)
{
   _ambigNumberDetails = ambigNumberDetails;
}


/**************************************************************************//**
 *
 ******************************************************************************/
void clSDS_Method_PhoneUpdatePhonebook::onActivePhoneDeviceError(
   const ::boost::shared_ptr< MOST_Tel_FI::MOST_Tel_FIProxy >& /*proxy*/,
   const ::boost::shared_ptr< MOST_Tel_FI::ActivePhoneDeviceError >& /*error*/)
{
}


/**************************************************************************//**
 *
 ******************************************************************************/
void clSDS_Method_PhoneUpdatePhonebook::onActivePhoneDeviceStatus(
   const ::boost::shared_ptr< MOST_Tel_FI::MOST_Tel_FIProxy >& /*proxy*/,
   const ::boost::shared_ptr< MOST_Tel_FI::ActivePhoneDeviceStatus >& /*status*/)
{
}
