/**************************************************************************//**
 * \file       clSDS_Method_PhoneSelectPhone.cpp
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#include "Sds2HmiServer/functions/clSDS_Method_PhoneSelectPhone.h"
#include "application/GuiService.h"
#include "external/sds2hmi_fi.h"
#include "SdsAdapter_Trace.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SDSADP_DETAILS
#include "trcGenProj/Header/clSDS_Method_PhoneSelectPhone.cpp.trc.h"
#endif


#define DEFAULT_PHONE_ID 65535


/**************************************************************************//**
* Destructor
******************************************************************************/
clSDS_Method_PhoneSelectPhone::~clSDS_Method_PhoneSelectPhone()
{
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clSDS_Method_PhoneSelectPhone::clSDS_Method_PhoneSelectPhone(ahl_tclBaseOneThreadService* pService,
      boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy > pTelProxy, GuiService& guiService)
   : clServerMethod(SDS2HMI_SDSFI_C_U16_PHONESELECTPHONE, pService)
   , _guiService(guiService)
   , _telephoneProxy(pTelProxy)
   , _multiPointPairing(false)
{
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clSDS_Method_PhoneSelectPhone::vMethodStart(amt_tclServiceData* pInMessage)
{
   sds2hmi_sdsfi_tclMsgPhoneSelectPhoneMethodStart oMessage;
   vGetDataFromAmt(pInMessage, oMessage);
   handleMethodStart(oMessage);
}


/**************************************************************************//**
*
******************************************************************************/
void clSDS_Method_PhoneSelectPhone::handleMethodStart(sds2hmi_sdsfi_tclMsgPhoneSelectPhoneMethodStart& oMessage)
{
   if (_telephoneProxy->isAvailable() && (oMessage.PhoneID != DEFAULT_PHONE_ID) && _multiPointPairing)
   {
      _telephoneProxy->sendSetActivePhoneStart(*this, oMessage.PhoneID);
   }
   else
   {
      _guiService.sendEventSignal(sds_gui_fi::SdsGuiService::Event__SPEECH_DIALOG_SELECT_PAIRED_DEVICE_LIST);
      vSendMethodResult();
   }
}


/**************************************************************************//**
*
******************************************************************************/
void clSDS_Method_PhoneSelectPhone::onSetActivePhoneError(const ::boost::shared_ptr< MOST_Tel_FI::MOST_Tel_FIProxy >& /*proxy*/,
      const ::boost::shared_ptr< MOST_Tel_FI::SetActivePhoneError >& /*error*/)
{
   vSendErrorMessage(SDS2HMI_SDSFI_C_U16_ERROR_CANNOTCOMPLETEACTION);
}


/**************************************************************************//**
*
******************************************************************************/
void clSDS_Method_PhoneSelectPhone::onSetActivePhoneResult(const ::boost::shared_ptr< MOST_Tel_FI::MOST_Tel_FIProxy >& /*proxy*/,
      const ::boost::shared_ptr< MOST_Tel_FI::SetActivePhoneResult >& /*result*/)
{
   vSendMethodResult();
}


/**************************************************************************//**
*
******************************************************************************/
void clSDS_Method_PhoneSelectPhone::multiPointPairingEnabled(bool multiPointPairingStatus)
{
   _multiPointPairing = multiPointPairingStatus;
}
