/**************************************************************************//**
 * \file       clSDS_Method_PhoneDialNumber.h
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_Method_PhoneDialNumber_h
#define clSDS_Method_PhoneDialNumber_h


#include "Sds2HmiServer/framework/clServerMethod.h"
#include "external/sds2hmi_fi.h"
#include "MOST_Tel_FIProxy.h"
#include "MOST_PhonBk_FIProxy.h"


class clSDS_ListScreen;
class PhonebookContacts;
class AudioSourceHandler;
class GuiService;


class clSDS_Method_PhoneDialNumber
   : public clServerMethod
   , public MOST_Tel_FI::DialCallbackIF
   , public MOST_PhonBk_FI::GetContactDetailsExtendedCallbackIF
{
   public:
      virtual ~clSDS_Method_PhoneDialNumber();
      clSDS_Method_PhoneDialNumber(
         ahl_tclBaseOneThreadService* pService, clSDS_ListScreen* pListScreen,
         PhonebookContacts* pPhonebookContacts,
         ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy > telephoneProxy,
         ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy > phonebookProxy,
         AudioSourceHandler* pAudioSourceHandler,
         GuiService& guiService);

      virtual void onDialError(
         const ::boost::shared_ptr< MOST_Tel_FI::MOST_Tel_FIProxy >& proxy,
         const ::boost::shared_ptr< MOST_Tel_FI::DialError >& error);
      virtual void onDialResult(
         const ::boost::shared_ptr< MOST_Tel_FI::MOST_Tel_FIProxy >& proxy,
         const ::boost::shared_ptr< MOST_Tel_FI::DialResult >& result);

      virtual void onGetContactDetailsExtendedError(
         const ::boost::shared_ptr< MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& proxy,
         const ::boost::shared_ptr< MOST_PhonBk_FI::GetContactDetailsExtendedError >& error);
      virtual void onGetContactDetailsExtendedResult(
         const ::boost::shared_ptr< MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& proxy,
         const ::boost::shared_ptr< MOST_PhonBk_FI::GetContactDetailsExtendedResult >& result);

   private:
      virtual void vMethodStart(amt_tclServiceData* pInMsg);
      void vInvokeDialNumber(const sds2hmi_sdsfi_tclMsgPhoneDialNumberMethodStart& oMessage);
      void vDialNumberByValue(std::string strPhoneNumber);
      void vDialByIndex(tU32 u32Index);
      void vDialNumberByUWID(tU32 u32UwId);

      boost::shared_ptr< MOST_Tel_FI::MOST_Tel_FIProxy > _telephoneProxy;
      boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy > _phonebookProxy;
      PhonebookContacts* _pPhonebookContacts;
      clSDS_ListScreen* _pListScreen;
      AudioSourceHandler* _pAudioSourceHandler;
      GuiService& _guiService;
};


#endif
