/**************************************************************************//**
 * \file       clSDS_Method_NaviValidateDestinationEntries.h
 *
 * VC FC Service Message handler functions
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_Method_NaviValidateDestinationEntries_h
#define clSDS_Method_NaviValidateDestinationEntries_h


#include "org/bosch/cm/navigation/NavigationServiceProxy.h"
#include "application/NdsCountryStateObserver.h"
#include "application/NdsCountryStateRequestor.h"
#include "application/clSDS_KDSConfiguration.h"
#include "application/clSDS_LanguageMediator.h"
#include "Sds2HmiServer/framework/clServerMethod.h"
#include "external/sds2hmi_fi.h"


using namespace org::bosch::cm::navigation::NavigationService;


class clSDS_Method_NaviValidateDestinationEntries
   : public clServerMethod
   , public asf::core::ServiceAvailableIF
   , public SdsCheckAddressCallbackIF
   , public SdsAddressWithOptionsCallbackIF
   , public NdsCountryStateObserver
{
   public:

      virtual ~clSDS_Method_NaviValidateDestinationEntries();

      clSDS_Method_NaviValidateDestinationEntries(
         ahl_tclBaseOneThreadService* pService,
         ::boost::shared_ptr< NavigationServiceProxy> naviProxy,
         NdsCountryStateRequestor* pNdsCountryStateRequestor,
         clSDS_LanguageMediator* pLanguageMediator);

      void onUnavailable(
         const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange);
      void onAvailable(
         const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange);

      // callbacks by SdsCheckAddressCallbackIF
      virtual void onSdsCheckAddressError(
         const ::boost::shared_ptr<NavigationServiceProxy>& proxy,
         const ::boost::shared_ptr< SdsCheckAddressError >& error);
      virtual void onSdsCheckAddressResponse(
         const ::boost::shared_ptr< NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< SdsCheckAddressResponse >& sdsCheckAddressResponse);

      // SdsAddressWithOptionsCallbackIF
      virtual void onSdsAddressWithOptionsUpdate(
         const ::boost::shared_ptr< NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< SdsAddressWithOptionsUpdate >& update);
      virtual void onSdsAddressWithOptionsError(
         const ::boost::shared_ptr< NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< SdsAddressWithOptionsError >& error);

   private:

      std::vector< SDSAddressElement > _oRequestingsdsAddress;
      boost::shared_ptr<NavigationServiceProxy> _navigationProxy;
      NdsCountryStateRequestor* _pNdsCountryStateRequestor;
      clSDS_LanguageMediator* _pLanguageMediator;
      std::vector<sds2hmi_fi_tcl_DestinationItem> _destinationItemList;
      std::map<sds2hmi_fi_tcl_e8_SDSDestinationType::tenType, std::string> _requestedAddressMap;
      std::map<sds2hmi_fi_tcl_e8_SDSDestinationType::tenType, std::string> _verifiedAddressMap;
      tU32 _destinationItemId;
      std::vector<sds2hmi_fi_tcl_DestinationElement> _validatedList;
      bool _countryStateInfoAvailable;
      bool _countryStateInfoRequested;

      void vMethodStart(amt_tclServiceData* pInMessage);
      void sendValidationRequestToNavi();
      void getAddressOptionResultFromNavi();
      void setSDSCheckAddressFromAddressMap();
      void setRequestAddressMap(sds2hmi_fi_tcl_DestinationItem destinationItem);
      void setSDSAddressElement(const std::string& searchContent, SDSAddressElementType searchElement);
      void setVerifiedAddressMap(::std::vector< SDSAddressElement >& verifiedAddress);
      void sendSdsCheckAddressRequest();
      void getAddressValidationResultFromNavi();
      void setValidationResult(const SDSAddressOptions&  sdsAddressOptions);
      void sendMethodResult();
      void NdsCountryStateUpdated();
      std::string convertISOLanguageCodetoString(sds2hmi_fi_tcl_e16_ISO639_3_SDSLanguageCode languageCode);
};


#endif
