/**************************************************************************//**
 * \file       clSDS_Method_NaviStartDistanceDetour.h
 *
 * clSDS_Method_NaviStartDistanceDetour  class implementation
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_Method_NaviStartDistanceDetour_h
#define clSDS_Method_NaviStartDistanceDetour_h


#include "Sds2HmiServer/framework/clServerMethod.h"
#include "org/bosch/cm/navigation/NavigationServiceProxy.h"
#include "external/sds2hmi_fi.h"
#include "application/NaviDetourList.h"


class clSDS_Method_NaviStartDistanceDetour
   : public clServerMethod
   , public org::bosch::cm::navigation::NavigationService::SelectJamAheadListEntryCallbackIF
{
   public:
      clSDS_Method_NaviStartDistanceDetour(
         ahl_tclBaseOneThreadService* pService,
         ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy > naviProxy,
         NaviDetourList* pDetourList);
      virtual ~clSDS_Method_NaviStartDistanceDetour();

      virtual void onSelectJamAheadListEntryError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::SelectJamAheadListEntryError >& error);

      virtual void onSelectJamAheadListEntryResponse(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::SelectJamAheadListEntryResponse >& response);

   protected:
      virtual tVoid vMethodStart(amt_tclServiceData* pInMsg);

   private:
      ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy > _pNaviProxy;
      NaviDetourList* _pDetourList;
};


#endif
