/**************************************************************************//**
 * \file       clSDS_Method_NaviSetRouteCriteria.h
 *
 * VC FC Service Message handler functions
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_Method_NaviSetRouteCriteria_h
#define clSDS_Method_NaviSetRouteCriteria_h


#include "Sds2HmiServer/framework/clServerMethod.h"
#include "external/sds2hmi_fi.h"
#include "org/bosch/cm/navigation/NavigationServiceProxy.h"
#include "application/GuiService.h"


class clSDS_Method_NaviSetRouteCriteria
   : public clServerMethod
   , public org::bosch::cm::navigation::NavigationService::SetRouteCriterionCallbackIF
{
   public:
      virtual ~clSDS_Method_NaviSetRouteCriteria();
      clSDS_Method_NaviSetRouteCriteria(
         ahl_tclBaseOneThreadService* pService,
         ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy > pSds2NaviProxy,
         GuiService& guiService);

      virtual void onSetRouteCriterionError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::SetRouteCriterionError >& error);
      virtual void onSetRouteCriterionResponse(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::SetRouteCriterionResponse >& response);

   private:
      virtual tVoid vMethodStart(amt_tclServiceData* pInMsg);
      void vSendReCalculateRouteRequest(const sds2hmi_sdsfi_tclMsgNaviSetRouteCriteriaMethodStart& oMessage);
      boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy > _sds2NaviProxy;
      GuiService& _guiService;
};


#endif
