/**************************************************************************//**
 * \file       clSDS_Method_NaviSetMapMode.cpp
 *
 * NaviSetMapMode method class implementation
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#include "Sds2HmiServer/functions/clSDS_Method_NaviSetMapMode.h"
#include "application/NaviPOIIconsList.h"
#include "SdsAdapter_Trace.h"
#include "application/clSDS_ConfigurationFlags.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_SDSADP_DETAILS
#include "trcGenProj/Header/clSDS_Method_NaviSetMapMode.cpp.trc.h"
#endif


using namespace org::bosch::cm::navigation::NavigationService;


/**************************************************************************//**
* Destructor
******************************************************************************/
clSDS_Method_NaviSetMapMode::~clSDS_Method_NaviSetMapMode()
{
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clSDS_Method_NaviSetMapMode::clSDS_Method_NaviSetMapMode(
   ahl_tclBaseOneThreadService* pService,
   ::boost::shared_ptr< NavigationServiceProxy > naviProxy,
   GuiService& guiService,
   NaviPOIIconsList* naviPOIIconsList)

   : clServerMethod(SDS2HMI_SDSFI_C_U16_NAVISETMAPMODE, pService)
   , _naviProxy(naviProxy)
   , _guiService(guiService)
   , _naviPOIIconsList(naviPOIIconsList)
   , _mapRepresentation(MapRepresentation__MAP_REPRESENTATION_NOT_SET)
{
}


/**************************************************************************//**
*
******************************************************************************/
void clSDS_Method_NaviSetMapMode::vMethodStart(amt_tclServiceData* pInMessage)
{
   sds2hmi_sdsfi_tclMsgNaviSetMapModeMethodStart oMessage;
   vGetDataFromAmt(pInMessage, oMessage);
   vGetMapOrientationfromSDS(oMessage);
   vSendMethodResult();
}


/***********************************************************************//**
*
***************************************************************************/
void clSDS_Method_NaviSetMapMode::onAvailable(
   const boost::shared_ptr<asf::core::Proxy>& proxy,
   const asf::core::ServiceStateChange& /*stateChange*/)
{
   if (proxy == _naviProxy)
   {
      _naviProxy->sendMapRepresentationRegister(*this);
      _naviProxy->sendMapRepresentationGet(*this);
   }
}


/***********************************************************************//**
*
***************************************************************************/
void clSDS_Method_NaviSetMapMode::onUnavailable(
   const boost::shared_ptr<asf::core::Proxy>& proxy,
   const asf::core::ServiceStateChange& /*stateChange*/)
{
   if (proxy == _naviProxy)
   {
      _naviProxy->sendMapRepresentationDeregisterAll();
   }
}


/***********************************************************************//**
*
***************************************************************************/
void clSDS_Method_NaviSetMapMode::onMapRepresentationUpdate(
   const ::boost::shared_ptr< NavigationServiceProxy >& /*proxy*/,
   const ::boost::shared_ptr< MapRepresentationUpdate >& update)
{
   _mapRepresentation = update->getMapRepresentation();
   ETG_TRACE_USR4(("clSDS_Method_NaviSetMapMode::onMapRepresentationUpdate mapRepresentation %d", _mapRepresentation));
}


/***********************************************************************//**
*
***************************************************************************/
void clSDS_Method_NaviSetMapMode::onMapRepresentationError(
   const ::boost::shared_ptr< NavigationServiceProxy >& /*proxy*/,
   const ::boost::shared_ptr< MapRepresentationError >& /*error*/)
{
}


/***********************************************************************//**
*
***************************************************************************/
void clSDS_Method_NaviSetMapMode::onSetMapRepresentationResponse(
   const ::boost::shared_ptr< NavigationServiceProxy >& /*proxy*/,
   const ::boost::shared_ptr< SetMapRepresentationResponse >& /*response*/)
{
}


/***********************************************************************//**
*
***************************************************************************/
void clSDS_Method_NaviSetMapMode::onSetMapRepresentationError(
   const ::boost::shared_ptr< NavigationServiceProxy >& /*proxy*/,
   const ::boost::shared_ptr< SetMapRepresentationError >& /*error*/)
{
}


/***********************************************************************//**
*
***************************************************************************/

void clSDS_Method_NaviSetMapMode::vGetMapOrientationfromSDS(const sds2hmi_sdsfi_tclMsgNaviSetMapModeMethodStart& oMessage)
{
   MapmodeType enMapmodeType = UNKNOWN;

   switch (oMessage.nMapView.enType)
   {
      case sds2hmi_fi_tcl_e8_NAV_MapView::FI_EN_VIEW_2D:
      {
         enMapmodeType = VIEW_2D;
         break;
      }
      case sds2hmi_fi_tcl_e8_NAV_MapView::FI_EN_VIEW_3D:
      {
         enMapmodeType = VIEW_3D;
         break;
      }
      default:
      {
         break;
      }
   }

   switch (oMessage.nMapOrientation.enType)
   {
      case sds2hmi_fi_tcl_e8_NAV_MapOrientation::FI_EN_NORTH_UP:
      {
         enMapmodeType = NORTH_UP;
         break;
      }
      case sds2hmi_fi_tcl_e8_NAV_MapOrientation::FI_EN_HEADING:
      {
         enMapmodeType = HEADING;
         break;
      }
      default:
      {
         break;
      }
   }

   vSendMapviewRequest(oMessage.nTBTSymbols);

   ETG_TRACE_USR4(("clSDS_Method_NaviSetMapMode::vGetMapOrientationfromSDS enMapmodeType %d", enMapmodeType));

   vGetTargetMapOrientation(enMapmodeType);
   switch (oMessage.IconSetting.DisplayAction.enType)
   {
      case sds2hmi_fi_tcl_e8_NAV_IconDisplayAction::FI_EN_ICONDSPLY_SHOW:
      case sds2hmi_fi_tcl_e8_NAV_IconDisplayAction::FI_EN_ICONDSPLY_REMOVE:
      case sds2hmi_fi_tcl_e8_NAV_IconDisplayAction::FI_EN_ICONDSPLY_SHOWALL:
      case sds2hmi_fi_tcl_e8_NAV_IconDisplayAction::FI_EN_ICONDSPLY_REMOVEALL:
      {
         _naviPOIIconsList->sendGetDynamicPOIIconCategoriesRequest(oMessage.IconSetting);
      }
      break;
      default:
         break;
   }
}


/***********************************************************************//**
*
***************************************************************************/
void clSDS_Method_NaviSetMapMode::vGetTargetMapOrientation(MapmodeType enMapmodeType)
{
   org::bosch::cm::navigation::NavigationService::MapRepresentation enTargetMapRepresentation = MapRepresentation__MAP_REPRESENTATION_NOT_SET ;

   switch (_mapRepresentation)
   {
      case MapRepresentation__MAP_REPRESENTATION_NOT_SET:
      {
         if (enMapmodeType == VIEW_3D)
         {
            enTargetMapRepresentation = MapRepresentation__MAP_REPRESENTATION_3D_CAR_HEADING;
         }
         else if (enMapmodeType == VIEW_2D)
         {
            enTargetMapRepresentation = MapRepresentation__MAP_REPRESENTATION_2D_CAR_HEADING;
         }
         else if (enMapmodeType == HEADING)
         {
            enTargetMapRepresentation = MapRepresentation__MAP_REPRESENTATION_3D_CAR_HEADING;
         }
         else if (enMapmodeType == NORTH_UP)
         {
            enTargetMapRepresentation = MapRepresentation__MAP_REPRESENTATION_2D_NORTH_UP;
         }
         break;
      }
      case MapRepresentation__MAP_REPRESENTATION_3D_CAR_HEADING:
      {
         if (enMapmodeType == VIEW_3D)
         {
            enTargetMapRepresentation = MapRepresentation__MAP_REPRESENTATION_3D_CAR_HEADING;
         }
         else if (enMapmodeType == VIEW_2D)
         {
            enTargetMapRepresentation = MapRepresentation__MAP_REPRESENTATION_2D_CAR_HEADING;
         }
         else if (enMapmodeType == HEADING)
         {
            enTargetMapRepresentation = MapRepresentation__MAP_REPRESENTATION_3D_CAR_HEADING;
         }
         else if (enMapmodeType == NORTH_UP)
         {
            enTargetMapRepresentation = MapRepresentation__MAP_REPRESENTATION_2D_NORTH_UP;
         }
         break;
      }
      case MapRepresentation__MAP_REPRESENTATION_2D_CAR_HEADING:
      {
         if (enMapmodeType == VIEW_3D)
         {
            enTargetMapRepresentation = MapRepresentation__MAP_REPRESENTATION_3D_CAR_HEADING;
         }
         else if (enMapmodeType == VIEW_2D)
         {
            enTargetMapRepresentation = MapRepresentation__MAP_REPRESENTATION_2D_CAR_HEADING;
         }
         else if (enMapmodeType == HEADING)
         {
            enTargetMapRepresentation = MapRepresentation__MAP_REPRESENTATION_2D_CAR_HEADING;
         }
         else if (enMapmodeType == NORTH_UP)
         {
            enTargetMapRepresentation = MapRepresentation__MAP_REPRESENTATION_2D_NORTH_UP;
         }
         break;
      }
      case MapRepresentation__MAP_REPRESENTATION_2D_NORTH_UP:
      {
         if (enMapmodeType == VIEW_3D)
         {
            enTargetMapRepresentation = MapRepresentation__MAP_REPRESENTATION_3D_CAR_HEADING;
         }
         else if (enMapmodeType == VIEW_2D)
         {
            enTargetMapRepresentation = MapRepresentation__MAP_REPRESENTATION_2D_NORTH_UP;
         }
         else if (enMapmodeType == HEADING)
         {
            enTargetMapRepresentation = MapRepresentation__MAP_REPRESENTATION_2D_CAR_HEADING;
         }
         else if (enMapmodeType == NORTH_UP)
         {
            enTargetMapRepresentation = MapRepresentation__MAP_REPRESENTATION_2D_NORTH_UP;
         }
         break;
      }
      default:
      {
         break;
      }
   }
   ETG_TRACE_USR4(("clSDS_Method_NaviSetMapMode::vGetTargetMapOrientation enTargetMapRepresentation %d", enTargetMapRepresentation));

   if (MapRepresentation__MAP_REPRESENTATION_NOT_SET != enTargetMapRepresentation)
   {
      vSendMapOrientationtoNavi(enTargetMapRepresentation);
   }
}


/***********************************************************************//**
*
***************************************************************************/
void clSDS_Method_NaviSetMapMode::vSendMapviewRequest(const sds2hmi_fi_tcl_e8_NAV_TBT_Symbols& oNavTBTSymbols)
{
   switch (oNavTBTSymbols.enType)
   {
      case sds2hmi_fi_tcl_e8_NAV_TBT_Symbols::FI_EN_SYMBOLS_MIXED:
      {
         MapViewMode enMapviewmodeType = MapViewMode__MAP_VIEW_MODE_SPLIT_MAP;
         _naviProxy->sendShowMapScreenWithMapViewModeRequest(*this, enMapviewmodeType);

         _guiService.sendEventSignal(sds_gui_fi::SdsGuiService::Event__SPEECH_DIALOG_SHOW_NAVI_SOURCECHANGE_ACTIVE);
      }
      break;
      case sds2hmi_fi_tcl_e8_NAV_TBT_Symbols::FI_EN_SYMBOLS_OFF:
      {
         MapViewMode enMapviewmodeType = MapViewMode__MAP_VIEW_MODE_FULL_MAP;
         _naviProxy->sendShowMapScreenWithMapViewModeRequest(*this, enMapviewmodeType);
         _guiService.sendEventSignal(sds_gui_fi::SdsGuiService::Event__SPEECH_DIALOG_SHOW_NAVI_SOURCECHANGE_ACTIVE);
      }
      break;
      default:
         break;
   }
}


/***********************************************************************//**
*
***************************************************************************/

void clSDS_Method_NaviSetMapMode::vSendMapOrientationtoNavi(MapRepresentation enTargetMapRepresentation)
{
   _naviProxy->sendSetMapRepresentationRequest(*this, enTargetMapRepresentation);
   _guiService.sendEventSignal(sds_gui_fi::SdsGuiService::Event__SPEECH_DIALOG_SHOW_NAVI_SOURCECHANGE_ACTIVE);
}


/***********************************************************************//**
*
***************************************************************************/
void clSDS_Method_NaviSetMapMode::onShowMapScreenWithMapViewModeError(
   const ::boost::shared_ptr< NavigationServiceProxy >& /*proxy*/,
   const ::boost::shared_ptr< ShowMapScreenWithMapViewModeError >& /*error*/)
{
}


/***********************************************************************//**
*
***************************************************************************/
void  clSDS_Method_NaviSetMapMode::onShowMapScreenWithMapViewModeResponse(
   const ::boost::shared_ptr< NavigationServiceProxy >& /* proxy*/,
   const ::boost::shared_ptr< ShowMapScreenWithMapViewModeResponse >& /*response*/)
{
}
