/**************************************************************************//**
 * \file       clSDS_Method_NaviSetDestinationItem.h
 *
 * VC FC Service Message handler functions
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_Method_NaviSetDestinationItem_h
#define clSDS_Method_NaviSetDestinationItem_h


#include "application/CountryNameObserver.h"
#include "application/NdsCountryStateObserver.h"
#include "application/NdsCountryStateRequestor.h"
#include "Sds2HmiServer/framework/clServerMethod.h"
#include "external/sds2hmi_fi.h"
#include "org/bosch/cm/navigation/NavigationServiceProxy.h"
#include "application/clSDS_NaviAmbiguitylistObserver.h"
#include "application/ChargingStationListObserver.h"
#include "application/clSDS_KDSConfiguration.h"
#include "application/clSDS_LanguageMediator.h"


class clSDS_POIList;
class clSDS_NaviListItems;
class clSDS_Method_CommonShowDialog;
class clSDS_MultipleDestinationsList;
class CountryNameRequestor;
class QuickChargingStation;
class GuiService;
class NaviHapticHandOverInterface;


class clSDS_Method_NaviSetDestinationItem
   : public clServerMethod
   , public clSDS_NaviAmbiguitylistObserver
   , public asf::core::ServiceAvailableIF
   , public org::bosch::cm::navigation::NavigationService::SdsCheckAddressCallbackIF
   , public org::bosch::cm::navigation::NavigationService::SetLocationWithSdsInputCallbackIF
   , public org::bosch::cm::navigation::NavigationService::SdsAddressWithOptionsCallbackIF
   , public org::bosch::cm::navigation::NavigationService::SelectSdsRefinementCallbackIF
   , public org::bosch::cm::navigation::NavigationService::RequestFreeTextSearchResultsCallbackIF
   , public org::bosch::cm::navigation::NavigationService::SetLocationWithFreeTextSearchInputCallbackIF
   , public org::bosch::cm::navigation::NavigationService::DestinationInformationCallbackIF
   , public CountryNameObserver
   , public org::bosch::cm::navigation::NavigationService::RequestDetailsForSelectedLocationCallbackIF
   , public org::bosch::cm::navigation::NavigationService::MenuPoiCategoryShortcutsCallbackIF
   , public ChargingStationListObserver
   , public NdsCountryStateObserver
   , public org::bosch::cm::navigation::NavigationService::SetLocationWithFixedPOICategoryInputCallbackIF
{
   public:
      virtual ~clSDS_Method_NaviSetDestinationItem();

      clSDS_Method_NaviSetDestinationItem(
         ahl_tclBaseOneThreadService* pService,
         ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy> naviProxy,
         clSDS_MultipleDestinationsList* pMultipleDestinationList,
         clSDS_POIList* pPOIList,
         clSDS_NaviListItems* pNaviListItems,
         clSDS_Method_CommonShowDialog* pCommonShowDialog,
         CountryNameRequestor* pCountryNameRequestor,
         QuickChargingStation* pQuickChargingStation,
         NaviHapticHandOverInterface* pNaviHapticHandOverInterface,
         clSDS_LanguageMediator* pLanguageMediator,
         NdsCountryStateRequestor* pNdsCountryStateRequestor,
         GuiService* pGuiService);

      void onUnavailable(
         const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange);
      void onAvailable(
         const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange);

      // callbacks by SdsCheckAddressCallbackIF
      virtual void onSdsCheckAddressError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy>& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::SdsCheckAddressError >& error);
      virtual void onSdsCheckAddressResponse(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::SdsCheckAddressResponse >& sdsCheckAddressResponse);

      // SetLocationWithSdsInputCallbackIF
      virtual void onSetLocationWithSdsInputError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::SetLocationWithSdsInputError >& error);
      virtual void onSetLocationWithSdsInputResponse(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::SetLocationWithSdsInputResponse >& response);

      // SdsAddressWithOptionsCallbackIF
      virtual void onSdsAddressWithOptionsUpdate(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::SdsAddressWithOptionsUpdate >& update);
      virtual void onSdsAddressWithOptionsError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::SdsAddressWithOptionsError >& error);

      //SdsSelectRefinementCallbackIF
      virtual void onSelectSdsRefinementError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::SelectSdsRefinementError >& error);
      virtual void onSelectSdsRefinementResponse(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::SelectSdsRefinementResponse >& response);

      //DestinationInformationCallbackIF
      virtual void onDestinationInformationError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::DestinationInformationError >& error);
      virtual void onDestinationInformationUpdate(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::DestinationInformationUpdate >& update);

      //RequestFreeTextSearchResultsCallbackIF
      virtual void onRequestFreeTextSearchResultsError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::RequestFreeTextSearchResultsError >& error);
      virtual void onRequestFreeTextSearchResultsResponse(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::RequestFreeTextSearchResultsResponse >& response);

      //SetLocationWithFreeTextSearchInputCallbackIF
      virtual void onSetLocationWithFreeTextSearchInputError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy>& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::SetLocationWithFreeTextSearchInputError >& error);
      virtual void onSetLocationWithFreeTextSearchInputResponse(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::SetLocationWithFreeTextSearchInputResponse >& response);

      //RequestDetailsForSelectedLocation
      virtual void onRequestDetailsForSelectedLocationError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::RequestDetailsForSelectedLocationError >& error);
      virtual void onRequestDetailsForSelectedLocationResponse(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::RequestDetailsForSelectedLocationResponse >& response);

      //RequestMenuPOICategoryShortcuts
      virtual void onMenuPoiCategoryShortcutsError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::MenuPoiCategoryShortcutsError >& error);
      virtual void onMenuPoiCategoryShortcutsUpdate(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::MenuPoiCategoryShortcutsUpdate >& update);

      virtual void onSetLocationWithFixedPOICategoryInputError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::SetLocationWithFixedPOICategoryInputError >& error);

      virtual void onSetLocationWithFixedPOICategoryInputResponse(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::SetLocationWithFixedPOICategoryInputResponse >& response);

      void vAmbiguityListResolved();
      void setLocationWithFixedPOICategoryCompleted();
      std::string convertISOLanguageCodetoString(sds2hmi_fi_tcl_e16_ISO639_3_SDSLanguageCode languageCode);

   private:
      enum enResultType
      {
         ADDRESS_MULTIPLE_RESULT_FOR_HOUSENR_OUTRANGE,
         ADDRESS_NOHOUSENO_RESULT,
         ADDRESS_HOUSENO_OUTRANGE_RESULT,
         ADDRESS_MULTIPLE_RESULT,
         ADDRESS_RESULT,
         JUNCTION_RESULT,
         STREET_INTERSECTION_RESULT,
         STREET_INTERSECTION_MULTIPLE_RESULT,
         POI_MULTIPLE_RESULT,
         AZA_HNO_RESULT,
         AZA_ONLY_RESULT,
         NO_RESULT
      };

      enum enRefinementType
      {
         ADDRESS_SEARCH_REFINEMENT_SELECTION,
         POI_SEARCH_REFINEMENT_SELECTION,
         NO_REFINEMENT_SELECTION
      };

      virtual tVoid vMethodStart(amt_tclServiceData* pInMsg);
      void listSelectionCriterionChanged(sds2hmi_fi_tcl_e16_SelectionCriterionType::tenType listType);
      bool isHouseNumberRequest() const;
      bool isOsdeAddressRequest() const;
      bool isPOISearchRequest() const;
      void sendAddressRequestToNavi();
      void getContentFromDescriptor();
      void NdsCountryStateUpdated();
      void handleHouseNrRequest();
      void handlePOIRequest();
      std::string getTaggedContent(const char* tag) const;
      void sendSdsCheckAddressRequest();
      tVoid requestPOIListToNavi();
      tVoid setSearchInformation(
         const std::string& searchContent,
         org::bosch::cm::navigation::NavigationService::SDSAddressElementType searchElement);
      tVoid handleVerifiedSdsAddress(::std::vector< org::bosch::cm::navigation::NavigationService::SDSAddressElement >& verifiedAddress);
      void sendDestinationResult(enResultType resultType);
      std::string getPOISearchString();
      tVoid resetResultValues();
      tVoid validateSdsAddressOptions(
         const org::bosch::cm::navigation::NavigationService::SDSAddressOptions& sdsAddressOptions,
         const ::std::vector< org::bosch::cm::navigation::NavigationService::SDSAddressElement >& verifiedAddress,
         const std::vector< org::bosch::cm::navigation::NavigationService::SDSAddressElementType >& sdsAddressElementType);
      void sendListEntrySelectionToNavi(tU8 ambigousValue);
      tVoid setDestinationResultforAmbiguity();
      bool setDestinationResultforNonAmbiguityRefinement();
      tVoid setDestinationResultforNonAmbiguityAddressresult();
      tVoid setDestinationResultforNonAmbiguity();
      void sendPOIResult(tU16 numberOfElements);
      std::vector< sds2hmi_fi_tcl_e16_SelectionCriterionType > getSelectionCriterionType(enResultType resultType);
      org::bosch::cm::navigation::NavigationService::FreeTextSearchScope getFreeTextSearchScope();
      bool isCountryRetrievalNecessary();
      void getAddressOptionResultFromNavi();
      void handleOSDERequest();
      void countriesUpdated();
      void findNextAddressElementType(const std::vector< org::bosch::cm::navigation::NavigationService::SDSAddressElementType >& sdsAddressElementType);
      void checkNextPossibleEntry(const ::std::vector< org::bosch::cm::navigation::NavigationService::SDSAddressElement >& verifiedAddress);
      void checkForMoreEntries();
      void handleDestinationItemResult();
      void setDestinationForNoHouseNr();
      void validateAddressOptions(const ::std::vector< org::bosch::cm::navigation::NavigationService::SDSAddressElement >& verifiedAddress);
      struct DescrtiptorDecider
      {
         std::string CountryName;
         std::string CityName;
         std::string StateName;
         std::string StreetName;
         std::string Aza;
         std::string Oaza;
         std::string CrossStreetName;
         std::string HouseNr;
         tBool bNavigable;
         tBool bAmbigous;
         tBool bHouseNrAvailable;
         tBool bHouseNrValid;
         tBool bCrossRoadAvailable;
         bool  removedInvalidEntry;
         bool  moreEntriesPossible;
         bool  azaAvailable;
         tBool bRefinement;
         org::bosch::cm::navigation::NavigationService::SDSAddressElementType ambigousElement;
      };

      struct POINames
      {
         std::string BrandName;
         std::string CategoryName;
         std::string BuildingName;
      };

      boost::shared_ptr<org::bosch::cm::navigation::NavigationService::NavigationServiceProxy> _navigationProxy;
      std::vector< org::bosch::cm::navigation::NavigationService::SDSAddressElement > _oRequestedsdsAddress;
      std::vector< org::bosch::cm::navigation::NavigationService::SDSAddressElement > _firstRequestedsdsAddress;
      DescrtiptorDecider _oResultDescriptor;
      POINames _oPOIName;
      clSDS_MultipleDestinationsList* _pMultipleDestiantionList;
      clSDS_POIList* _pPOIList;
      clSDS_NaviListItems* _pNaviListItems;
      clSDS_Method_CommonShowDialog* _pCommonShowDialog;
      CountryNameRequestor*  _pCountryNameRequestor;
      QuickChargingStation* _pQuickChargingStation;
      NaviHapticHandOverInterface* _pNaviHapticHandOverInterface;
      enRefinementType _refinmentType;

      sds2hmi_fi_tcl_e8_NAV_LocationType _locationType;
      std::vector< sds2hmi_fi_tcl_LocationDescriptor > _locationDescriptors;
      std::vector< org::bosch::cm::navigation::NavigationService::PoiCategoryShortcut > _sdsPOICategory;

      std::string removeDescriptorInformation(std::string addressString, const std::string& descriptorType) const;
      std::string removeOazafromReceivedAddress(std::string addressString) const;
      std::string setPOISearchStringForNavi(std::string, std::string , std::string) const;
      uint32 getSdsPOICategoryId(std::string categoryName);
      bool _houseNumberSetForFTS;
      bool _refinementValid;
      bool _countryStateInfoRequested;
      clSDS_LanguageMediator* _pLanguageMediator;
      NdsCountryStateRequestor* _pNdsCountryStateRequestor;
      GuiService* _pGuiService;
};


#endif
