/**************************************************************************//**
 * \file       clSDS_Method_NaviSelectDestListEntry.cpp
 *
 * clSDS_Method_NaviSelectDestListEntry method class implementation
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#include "Sds2HmiServer/functions/clSDS_Method_NaviSelectDestListEntry.h"
#include "external/sds2hmi_fi.h"
#include "application/clSDS_NaviListItems.h"
#include "SdsAdapter_Trace.h"
#include "application/NaviVoiceTagHandler.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_SDSADP_DETAILS
#include "trcGenProj/Header/clSDS_Method_NaviSelectDestListEntry.cpp.trc.h"
#endif


using namespace org::bosch::cm::navigation::NavigationService;


/**************************************************************************//**
* Destructor
******************************************************************************/
clSDS_Method_NaviSelectDestListEntry::~clSDS_Method_NaviSelectDestListEntry()
{
   _pNaviListItems = NULL;
   _pNaviVoiceTagHandler = NULL;
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clSDS_Method_NaviSelectDestListEntry::clSDS_Method_NaviSelectDestListEntry(
   ahl_tclBaseOneThreadService* pService,
   clSDS_NaviListItems* pNaviListItems,
   ::boost::shared_ptr<org::bosch::cm::navigation::NavigationService::NavigationServiceProxy > naviProxy,
   NaviVoiceTagHandler* pNaviVoiceTagHandler)
   : clServerMethod(SDS2HMI_SDSFI_C_U16_NAVISELECTDESTLISTENTRY, pService)
   , _naviProxy(naviProxy)
   , _pNaviListItems(pNaviListItems)
   , _pNaviVoiceTagHandler(pNaviVoiceTagHandler)
{
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clSDS_Method_NaviSelectDestListEntry::vMethodStart(amt_tclServiceData* pInMessage)
{
   sds2hmi_sdsfi_tclMsgNaviSelectDestListEntryMethodStart oMessage;
   vGetDataFromAmt(pInMessage, oMessage);
   _pNaviListItems->vSetNaviDestListType(oMessage.nListEntryType.enType);

   switch (oMessage.nListEntryType.enType)
   {
      case sds2hmi_fi_tcl_e8_NAV_ListType::FI_EN_HOME_DEST:
      {
         if (isHomeDestinationAvailable())
         {
            vSendMethodResult();
         }
         else
         {
            vSendErrorMessage(SDS2HMI_SDSFI_C_U16_ERROR_NOHOMEADDRESSAVAILABLE);
         }

         break;
      }
      case sds2hmi_fi_tcl_e8_NAV_ListType::FI_EN_WORK_DEST:
      {
         if (isWorkDestinationAvailable())
         {
            vSendMethodResult();
         }
         else
         {
            vSendErrorMessage(SDS2HMI_SDSFI_C_U16_ERROR_NOWORKADDRESSAVAILABLE);
         }

         break;
      }
      case sds2hmi_fi_tcl_e8_NAV_ListType::FI_EN_PERSISTANT_DEST:
      {
         ETG_TRACE_USR4((" clSDS_Method_NaviSelectDestListEntry::Persistant Dest"));
         if (oMessage.nSelectionType.enType == sds2hmi_fi_tcl_e8_GEN_SelectionType::FI_EN_BYUSW)
         {
            ETG_TRACE_USR4((" clSDS_Method_NaviSelectDestListEntry:: by userword"));
            _pNaviVoiceTagHandler->setVoiceTagMemoryID(oMessage.nIDValue);
            vSendMethodResult();
         }
      }
      break;
      default:
      {
         //TODO send a generic methodError message
         break;
      }
   }
}


/**************************************************************************//**
*
******************************************************************************/
bool clSDS_Method_NaviSelectDestListEntry::isHomeDestinationAvailable()
{
   if (_naviProxy->hasHomeLocation() && _naviProxy->getHomeLocation().getValid())
   {
      return true;
   }
   return false;
}


/**************************************************************************//**
*
******************************************************************************/
bool clSDS_Method_NaviSelectDestListEntry::isWorkDestinationAvailable()
{
   if (_naviProxy->hasWorkLocation() && _naviProxy->getWorkLocation().getValid())
   {
      return true;
   }
   return false;
}


/**************************************************************************//**
*
******************************************************************************/
void clSDS_Method_NaviSelectDestListEntry::onHomeLocationError(
   const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& /*proxy*/,
   const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::HomeLocationError >& /*error*/)
{
   ETG_TRACE_USR4(("clSDS_Method_NaviSelectDestListEntry::onHomeLocationError"));
}


/**************************************************************************//**
*
******************************************************************************/
void clSDS_Method_NaviSelectDestListEntry::onHomeLocationUpdate(
   const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& /*proxy*/,
   const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::HomeLocationUpdate >& /*update*/)
{
}


/**************************************************************************//**
*
******************************************************************************/
void clSDS_Method_NaviSelectDestListEntry::onWorkLocationError(
   const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& /*proxy*/,
   const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::WorkLocationError >& /*error*/)
{
   ETG_TRACE_USR4(("clSDS_Method_NaviSelectDestListEntry::onWorkLocationError"));
}


/**************************************************************************//**
*
******************************************************************************/
void clSDS_Method_NaviSelectDestListEntry::onWorkLocationUpdate(
   const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& /*proxy*/,
   const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::WorkLocationUpdate >& /*update*/)
{
}


/**************************************************************************//**
*
******************************************************************************/
void clSDS_Method_NaviSelectDestListEntry::onAvailable(const boost::shared_ptr<asf::core::Proxy>& proxy,
      const asf::core::ServiceStateChange& /*stateChange*/)
{
   if (proxy == _naviProxy)
   {
      _naviProxy->sendHomeLocationRegister(*this);
      _naviProxy->sendHomeLocationGet(*this);
      _naviProxy->sendWorkLocationRegister(*this);
      _naviProxy->sendWorkLocationGet(*this);
   }
}


/**************************************************************************//**
*
******************************************************************************/
void clSDS_Method_NaviSelectDestListEntry::onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy,
      const asf::core::ServiceStateChange& /*stateChange*/)
{
   if (proxy == _naviProxy)
   {
      _naviProxy->sendHomeLocationDeregisterAll();
      _naviProxy->sendWorkLocationDeregisterAll();
   }
}
